require 'test_helper'

class Forums::Public::TopicsTest < ActionDispatch::IntegrationTest

  def setup
    provider = FactoryGirl.create(:provider_account)
    @forum   = FactoryGirl.create(:forum, account: provider)
    @topic   = FactoryGirl.create(:topic, forum: @forum, user: provider.admins.first!)

    provider.settings.forum_enabled = true
    provider.settings.forum_public  = true

    host! provider.domain
  end

  def test_request_formats
    assert_raise(ActionController::UnknownFormat) do
      get forum_topic_path(id: @topic.permalink, format: :zip)
    end

    get forum_topic_path(id: @topic.permalink)
    assert_response :success

    get forum_topic_path(id: @topic.permalink, format: :html)
    assert_response :success
  end
end
