require File.expand_path(File.dirname(__FILE__) + '/../../test_helper')

class AuthorizeNetTest < ActionDispatch::IntegrationTest
  def setup
    @provider_account, plan = create_provider_account

    @provider_account.settings.allow_finance! unless @provider_account.settings.finance.allowed?
    @provider_account.settings.show_finance! unless @provider_account.settings.finance.visible?

    @buyer_account = Factory(:buyer_account, :provider_account => @provider_account)
    @buyer_account.buy!(plan)
    host! @provider_account.domain
  end

  test "navigate to the correct link" do
    login_with @buyer_account.admins.first.username, 'supersecret'
    get "/admin/account/"

    details_url = "/admin/account/authorize_net"
    assert_select('a[href=?]', details_url)
  end

  # test "new users get AddProfile link" do
  #   login_with @buyer_account.admins.first.username, 'supersecret'
  #   @buyer_account.credit_card_auth_code = nil
  #   @buyer_account.credit_card_authorize_net_payment_profile_token = nil

  #   get "/admin/account/authorize_net"

  #   assert_select('form[action=?]', "https://test.authorize.net/profile//AddPayment")
  # end

  # test "old users without credit card get AddProfile link" do
  #   login_with @buyer_account.admins.first.username, 'supersecret'
  #   @buyer_account.credit_card_auth_code= 'code'
  #   get "/admin/account/authorize_net"
  #   assert_select('form[action=?]', "https://test.authorize.net/profile//AddPayment")
  # end

  # test "old users with credit card get editProfile link" do
  #   login_with @buyer_account.admins.first.username, 'supersecret'
  #   @buyer_account.credit_card_auth_code= 'code'
  #   get "/admin/account/authorize_net"
  #   assert_select('form[action=?]', "https://test.authorize.net/profile//editPayment")
  # end

  def create_provider_account
    provider_account = Factory(:provider_with_billing, :payment_gateway_type => :authorize_net, :payment_gateway_options => {:login => 'foo', :password => 'bar'})
    provider_account.billing_strategy = Factory(:postpaid_with_charging)

    plan = Factory(:application_plan, :issuer => provider_account.default_service)

    [provider_account, plan]
  end
end
