require 'test_helper'

class Abilities::MasterAdminTest < ActiveSupport::TestCase

  def setup
    @account = FactoryGirl.build_stubbed(:simple_master)
    @admin  = FactoryGirl.build_stubbed(:simple_admin, account: @account)
  end

  def test_account
    assert_can ability, :manage, @account
  end

  def test_user
    assert_can ability, :manage, @admin

    assert_cannot ability, :destroy, @admin
    assert_cannot ability, :update_role, @admin
  end

  private

  def ability
    Ability.new(@admin)
  end
end
