require 'test_helper'

class Account::BillingAddressTest < ActiveSupport::TestCase

  def setup
    @account = Factory(:simple_account, provider_account: Factory(:simple_provider),
                       org_name: 'PP' , org_legaladdress: "Palacio Moncloa", billing_address_address1: 'C.Genova')
  end

  test '#billing_address?' do
    account = Account.new

    assert account.billing_address
    refute account.billing_address?

    account.billing_address = { name: 'foo' }
    assert account.billing_address?
  end


  test 'address_for_invoice returns address if present' do
    assert_equal 'Palacio Moncloa', @account.address_for_invoice.line1
  end

  test 'address_for_invoice cascades to billing address' do
    @account.update_attribute :org_legaladdress, ""
    assert_equal 'C.Genova', @account.address_for_invoice.line1
  end

  test 'billing_address=' do
    account = Account.new
    error = assert_raises(Account::BillingAddress::AddressFormatError) do
      account.billing_address = 'Carrer Napols 187, Barcelona'
    end

    assert_equal account, error.object
  end
end
