require 'test_helper'

class ApiDocs::ProviderUserDataTest < ActiveSupport::TestCase
  def setup
    @admin = FactoryGirl.build_stubbed(:simple_user, role: :admin)
  end

  def test_access_tokens_field_with_hint
    data = ApiDocs::ProviderUserData.new(@admin).as_json[:results]
    assert_equal [{ name: 'First create an access token in the Personal Settings section.',
                   value: '' }], data[:access_token]
  end

  def test_service_tokens
    User.any_instance.stubs(admin_sections: [:services])

    data = ApiDocs::ProviderUserData.new(@admin).as_json[:results]
    assert_equal [{ name: "You don't have access to any services, contact an administrator of this account.",
                    value: '' }], data[:service_tokens]

    service = FactoryGirl.create(:simple_service, account: @admin.account)
    service_other = FactoryGirl.create(:simple_service, account: @admin.account)
    _service_without_token = FactoryGirl.create(:simple_service, account: @admin.account)
    service.service_tokens.create!(value: 'Foo')
    service_other.service_tokens.create!(value: 'Bar')

    admin_data = ApiDocs::ProviderUserData.new(@admin).as_json[:results]
    assert_equal [{ name: service.name, value: 'Foo' }, { name: service_other.name, value: 'Bar' }], admin_data[:service_tokens]

    member = FactoryGirl.create(:simple_user, account: @admin.account)
    member.stubs(member_permission_service_ids: [service.id])
    member.expects(:has_permission?).with(:plans).returns(true)

    data1 = ApiDocs::ProviderUserData.new(member).as_json[:results]
    assert_equal [{ name: service.name, value: 'Foo' }], data1[:service_tokens]
  end
end
