class BillingMailerTest < ActionMailer::TestCase

  def setup
    ActionMailer::Base.deliveries = []
  end

  test "success" do
    results = Finance::BillingStrategy::Results.new(Time.now)

    BillingMailer.billing_finished(results).deliver

    email = ActionMailer::Base.deliveries.last
    assert_match "Billing and charging succeeded", email.subject
    assert_equal ['system-dev@3scale.net'], email.to
  end

  test "failure" do
    results = Finance::BillingStrategy::Results.new(Time.now)
    results.stubs(:successful?).returns(false)

    BillingMailer.billing_finished(results).deliver

    email = ActionMailer::Base.deliveries.last
    assert_match "Billing and charging failed", email.subject
    assert_equal ['system-dev@3scale.net'], email.to
  end
end
