require 'test_helper'

class Finance::InvoiceProxyTest < ActiveSupport::TestCase

  context 'InvoiceProxy' do

    setup do
      fake_model = Factory(:provider_with_billing)
      @month = Month.new(Time.zone.now)
      @proxy = Finance::InvoiceProxy.new(fake_model, fake_model, @month)
      @item = stub('item', :name => 'name', :cost => 43)
      @invoice = mock('invoice')
      @invoice.stubs(:line_items).returns([])
    end

    context 'when invoice exists' do
      setup { Invoice.expects(:opened_by_buyer).returns(@invoice) }

      should("call its :bill method and be marked as 'used'") do
        @invoice.expects(:bill).with(@item)
        @proxy.bill(@item)
        assert @proxy.used?
      end

      should "delegate calls to it" do
        assert_equal 0, @proxy.line_items.count
      end
    end

    context 'when no invoice exist' do
      setup do
        Invoice.stubs(:by_month).with(@month.to_param).returns(
         stub(:opened_by_buyer => @invoice))
      end

      should("creates one and bills it") do
        @invoice.expects(:bill).with(@item)
        @proxy.bill(@item)
      end
    end

  end
end
