require 'test_helper'

class ApplicationHelperTest < ActionView::TestCase
  attr_accessor :current_user
  delegate :can?, to: :ability

  def test_link_to_export_widget_for
    self.current_user = FactoryGirl.build_stubbed(:member, account: account)
    link = link_to_export_widget_for('Accounts')
    assert_equal nil, link

    self.current_user = FactoryGirl.build_stubbed(:admin, account: account)
    link = link_to_export_widget_for('Accounts')
    assert_match /a/, link
  end

  private

  def ability
    Ability.new(current_user)
  end

  def account
    @account ||= FactoryGirl.build_stubbed(:simple_provider)
  end
end
