require 'test_helper'

class Liquid::Drops::CurrentUserDropTest < ActiveSupport::TestCase
  include Liquid

  def setup
    @user = FactoryGirl.build(:user_with_account)
    @drop = Drops::CurrentUser.new(@user)
  end

  test "#can" do
    assert @drop.respond_to?(:can)
    assert_kind_of Liquid::Drops::CurrentUser::Can, @drop.can
  end

  # test "#can.manage_multiple_users?" do
  #   assert @drop.can.respond_to?(:manage_multiple_users?)
  # end

  test "#can.invite_users?" do
    assert @drop.can.respond_to?(:invite_users?)
  end

  test "#can.create_application?" do
    assert @drop.can.respond_to?(:create_application?)
  end

  test "#can.see_log_requests?" do
    assert @drop.can.respond_to?(:see_log_requests?)
  end

  test "not respond to the User::Can methods" do
    assert !@drop.can.respond_to?(:be_destroyed?)
    assert !@drop.can.respond_to?(:be_managed?)
    assert !@drop.can.respond_to?(:be_update_role?)
  end
end
