require 'test_helper'

class Pdf::DispatchTest < ActiveSupport::TestCase
  test 'enqueues report worker' do
    account = FactoryGirl.create(:simple_provider)
    service = FactoryGirl.create(:simple_service, account: account)

    assert_difference PdfReportWorker.jobs.method(:count), 2 do
      Pdf::Dispatch.daily
    end
    first, second = PdfReportWorker.jobs.map { |job| job.fetch('args') }

    assert_equal [Account.master.first_service!.id, Account.master.id, 'day', 'daily_reports'], first
    assert_equal [service.id, account.id, 'day', 'daily_reports'], second
  end
end
