require 'minitest_helper'
require 'three_scale/analytics/user_classifier'

class ThreeScaleAnalyticsUserClassifierTest < MiniTest::Unit::TestCase

  def classifier(attributes, *args)
    ThreeScale::Analytics::UserClassifier.new(stub(attributes))
  end


  def test_has_3scale_email?
    refute classifier(email: 'peter@gmail.com').has_3scale_email?

    assert classifier(email: 'peter@3scale.net').has_3scale_email?
    assert classifier(email: 'peter@3scalesolutions.com').has_3scale_email?
    assert classifier(email: 'peter@3scale.ws').has_3scale_email?
    assert classifier(email: 'peter@3scale.com').has_3scale_email?
    assert classifier(email: 'peter@apicast.io').has_3scale_email?
    assert classifier(email: 'peter@3scalesolutions.net').has_3scale_email?

    assert classifier(email: 'SAM@3SCALE.NET').has_3scale_email?
  end


  def test_is_3scaleadmin?
    refute classifier(username: 'peter').is_3scaleadmin?

    assert classifier(username: '3scaleadmin').is_3scaleadmin?
  end

  def test_is_3scale?
    refute classifier(email: 'peter@gmail.com', username: 'peter').is_3scale?
    assert classifier(email: 'peter@gmail.com', username: '3scaleadmin').is_3scale?
    assert classifier(email: 'peter@3scale.net', username: '3scaleadmin').is_3scale?
    assert classifier(email: 'peter@3scale.net', username: 'peter').is_3scale?
  end

  def test_is_guest?
    assert classifier(email: nil, username: nil).is_guest?
    assert classifier(email: 'user@example.com', username: nil).is_guest?
    assert classifier(email: nil, username: 'user').is_guest?

    refute classifier(email: 'peter@3scale.net', username: 'peter').is_guest?
  end

  def test_account_type
    assert_equal 'customer', classifier(email: 'user@gmail.com', username: 'user').user_type

    assert_equal '3scale', classifier(email: 'user@gmail.com', username: '3scaleadmin').user_type
    assert_equal '3scale', classifier(email: 'user@3scale.net', username: 'user').user_type
    assert_equal '3scale', classifier(email: 'user@3scale.net', username: '3scaleadmin').user_type

    assert_equal 'guest', classifier(email: nil, username: nil).user_type
    assert_equal 'guest', classifier(email: 'user@example.com', username: nil).user_type
    assert_equal 'guest', classifier(email: nil, username: 'user').user_type

    assert_equal 'guest', ThreeScale::Analytics::UserClassifier.new(nil).user_type
  end
end
