require 'test_helper'
require 'mail'

class LeMailer < ActionMailer::Base

  def bienvenu
    headers ::Message::APPLY_ENGAGEMENT_FOOTER => true
    mail to: 'me@3scale.net', body: "Le test message.", subject: "HELLO.", from: "me2@3scale.net"
  end

  def aurevoir
    headers ::Message::APPLY_ENGAGEMENT_FOOTER => false
    mail to: 'me@3scale.net', body: "Le test.", subject: "HELLO.", from: "me2@3scale.net"
  end
end

class ThreeScale::EmailEngagementFooterTest < ActiveSupport::TestCase

  test "interceptor for action mailer" do
    email = LeMailer.bienvenu.deliver

    assert_match email.body, /3scale API/

    email = LeMailer.aurevoir.deliver
    assert_equal email.body, "Le test."
  end
end
