require 'test_helper'

class DeleteServiceWorkerTest < ActiveSupport::TestCase
  def setup
    @service = FactoryGirl.create(:simple_service)
  end

  def test_enqueue
    DeleteServiceWorker.expects(:perform_async).with(@service.id)
    DeleteServiceWorker.enqueue(@service.id)
  end

  def test_perform
    service = FactoryGirl.create(:simple_service, account: @service.account)
    refute service.default?

    worker = DeleteServiceWorker.new
    worker.perform(service.id)

    assert_raise(ActiveRecord::RecordNotFound) do
      service.reload
    end
  end
end
