/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.SyncFailedException;

public class ShadowingStore
extends FileSystemStore {
    public static final char HIDDINGCHAR = '#';
    public static final char SHADOWCHAR = '!';

    @Override
    public int typeIs() {
        return 2;
    }

    @Override
    public int currentState(Uid objUid, String tName) throws ObjectStoreException {
        int theState = 0;
        if (this.storeValid()) {
            String path = this.genPathName(objUid, tName, 10);
            if (this.exists(path)) {
                theState = 2;
            } else if (this.exists(path = path + '#')) {
                theState = 6;
            } else {
                path = this.genPathName(objUid, tName, 11);
                if (this.exists(path)) {
                    theState = 1;
                } else if (this.exists(path = path + '#')) {
                    theState = 5;
                }
            }
        }
        if (tsLogger.arjLoggerI18N.debugAllowed()) {
            tsLogger.arjLoggerI18N.debug(16L, 4L, 16L, "com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_22", new Object[]{objUid, tName, ObjectStore.stateStatusString(theState)});
        }
        return theState;
    }

    @Override
    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.commit_state(" + objUid + ", " + tName + ")");
        }
        boolean result = false;
        if (!this.storeValid()) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_1");
            }
            return false;
        }
        if (tName != null) {
            String shadow = null;
            String filename = null;
            int state = this.currentState(objUid, tName);
            if (state == 6 || state == 2) {
                File originalState;
                File shadowState;
                shadow = this.genPathName(objUid, tName, 10);
                filename = this.genPathName(objUid, tName, 11);
                if (state == 6) {
                    shadow = shadow + '#';
                    filename = filename + '#';
                }
                if (!(result = this.renameFromTo(shadowState = new File(shadow), originalState = new File(filename)))) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_2", new Object[]{shadow, filename});
                    }
                } else {
                    super.addToCache(filename);
                    super.removeFromCache(shadow);
                }
                shadowState = null;
                originalState = null;
            } else {
                result = true;
            }
        } else {
            throw new ObjectStoreException("ShadowStore::commit_state - " + tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.notypenameuid") + objUid);
        }
        return result;
    }

    @Override
    public boolean hide_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.hide_state(" + objUid + ", " + tName + ")");
        }
        boolean hiddenOk = true;
        if (this.storeValid()) {
            int state = this.currentState(objUid, tName);
            String path1 = null;
            String path2 = null;
            switch (state) {
                case 5: 
                case 6: {
                    break;
                }
                case 1: {
                    path1 = this.genPathName(objUid, tName, 11);
                    path2 = new String(path1) + '#';
                    File newState = new File(path1);
                    File oldState = new File(path2);
                    if (this.renameFromTo(newState, oldState)) {
                        super.removeFromCache(path1);
                        super.addToCache(path2);
                    } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_3", new Object[]{newState, oldState});
                    }
                    newState = null;
                    oldState = null;
                    break;
                }
                case 2: {
                    path1 = this.genPathName(objUid, tName, 10);
                    path2 = new String(path1) + '#';
                    File newState = new File(path1);
                    File oldState = new File(path2);
                    if (this.renameFromTo(newState, oldState)) {
                        super.removeFromCache(path1);
                        super.addToCache(path2);
                    } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_3", new Object[]{newState, oldState});
                    }
                    newState = null;
                    oldState = null;
                    break;
                }
                default: {
                    hiddenOk = false;
                    break;
                }
            }
        } else {
            hiddenOk = false;
        }
        return hiddenOk;
    }

    @Override
    public boolean reveal_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.reveal_state(" + objUid + ", " + tName + ")");
        }
        boolean revealedOk = true;
        if (this.storeValid()) {
            int state = this.currentState(objUid, tName);
            String path1 = null;
            String path2 = null;
            switch (state) {
                case 6: {
                    path1 = this.genPathName(objUid, tName, 10);
                    path2 = new String(path1) + '#';
                    File newState = new File(path2);
                    File oldState = new File(path1);
                    if (this.renameFromTo(newState, oldState)) {
                        super.removeFromCache(path2);
                        super.addToCache(path1);
                    } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_4", new Object[]{newState, oldState});
                    }
                    newState = null;
                    oldState = null;
                    break;
                }
                case 5: {
                    path1 = this.genPathName(objUid, tName, 11);
                    path2 = new String(path1) + '#';
                    File newState = new File(path2);
                    File oldState = new File(path1);
                    if (this.renameFromTo(newState, oldState)) {
                        super.removeFromCache(path2);
                        super.addToCache(path1);
                    } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_4", new Object[]{newState, oldState});
                    }
                    newState = null;
                    oldState = null;
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    revealedOk = false;
                    break;
                }
            }
        } else {
            revealedOk = false;
        }
        return revealedOk;
    }

    @Override
    public ClassName className() {
        return ArjunaNames.Implementation_ObjectStore_ShadowingStore();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_ObjectStore_ShadowingStore();
    }

    public static ShadowingStore create() {
        return new ShadowingStore("");
    }

    public static ShadowingStore create(Object[] param) {
        int ss;
        String location;
        block5: {
            if (param == null) {
                return null;
            }
            location = (String)param[0];
            Integer shareStatus = (Integer)param[1];
            ss = 14;
            if (shareStatus != null) {
                try {
                    if (shareStatus == 13) {
                        ss = 13;
                    }
                }
                catch (Exception e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_5", new Object[]{e});
                }
            }
        }
        return new ShadowingStore(location, ss);
    }

    public static ShadowingStore create(ObjectName param) {
        if (param == null) {
            return null;
        }
        return new ShadowingStore(param);
    }

    @Override
    protected String genPathName(Uid objUid, String tName, int ft) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.genPathName(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(ft) + ")");
        }
        String fname = super.genPathName(objUid, tName, ft);
        if (ft == 10) {
            fname = fname + '!';
        }
        return fname;
    }

    @Override
    protected String revealedId(String name) {
        int index = name.indexOf(35);
        if (index == -1) {
            index = name.indexOf(33);
        }
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    @Override
    protected InputObjectState read_state(Uid objUid, String tName, int ft) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.read_state(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(ft) + ")");
        }
        if (!this.storeValid()) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_6");
            }
            return null;
        }
        InputObjectState new_image = null;
        if (tName != null) {
            int state = this.currentState(objUid, tName);
            if (state == 1 || state == 2) {
                if (state == 1 && ft != 11 || state == 2 && ft != 10) {
                    return null;
                }
                String fname = this.genPathName(objUid, tName, ft);
                File fd = this.openAndLock(fname, 0, false);
                if (fd != null) {
                    int imageSize = (int)fd.length();
                    byte[] buffer = new byte[imageSize];
                    FileInputStream ifile = null;
                    try {
                        ifile = new FileInputStream(fd);
                    }
                    catch (FileNotFoundException e) {
                        this.closeAndUnlock(fd, ifile, null);
                        throw new ObjectStoreException("ShadowingStore::read_state error: " + e);
                    }
                    try {
                        if (buffer != null && ifile.read(buffer, 0, imageSize) == imageSize) {
                            new_image = new InputObjectState(objUid, tName, buffer);
                        } else {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_7");
                        }
                    }
                    catch (IOException e) {
                        this.closeAndUnlock(fd, ifile, null);
                        throw new ObjectStoreException("ShadowingStore::read_state failed: " + e);
                    }
                    if (!this.closeAndUnlock(fd, ifile, null) && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_8", new Object[]{fname});
                    }
                }
            }
        } else {
            throw new ObjectStoreException("ShadowStore::read_state - " + tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.notypenameuid") + objUid);
        }
        return new_image;
    }

    @Override
    protected boolean remove_state(Uid objUid, String name, int ft) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.remove_state(" + objUid + ", " + name + ", " + ObjectStore.stateTypeString(ft) + ")");
        }
        boolean removeOk = true;
        if (!this.storeValid()) {
            return false;
        }
        if (name != null) {
            int state = this.currentState(objUid, name);
            if (state == 1 || state == 2) {
                String fname = this.genPathName(objUid, name, ft);
                File fd = this.openAndLock(fname, 1, false);
                if (fd != null) {
                    if (!fd.canWrite()) {
                        removeOk = false;
                        if (ft == 11) {
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_9", new Object[]{objUid, name});
                            }
                            if (!fd.exists() && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_10", new Object[]{objUid, name});
                            }
                        }
                    } else if (!fd.delete()) {
                        removeOk = false;
                        if (ft == 11 && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_11", new Object[]{fname});
                        }
                    }
                    this.closeAndUnlock(fd, null, null);
                } else {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_12", new Object[]{objUid});
                    }
                    removeOk = false;
                }
                if (removeOk) {
                    super.removeFromCache(fname);
                }
            } else {
                removeOk = false;
                if (state == 0) {
                    tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_14", new Object[]{objUid, name});
                } else {
                    tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_15", new Object[]{objUid, name});
                }
            }
        } else {
            removeOk = false;
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_17", new Object[]{objUid});
            }
        }
        return removeOk;
    }

    @Override
    protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int ft) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.write_state(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(ft) + ")");
        }
        if (!this.storeValid()) {
            return false;
        }
        if (tName != null) {
            String fname = this.genPathName(objUid, tName, ft);
            File fd = this.openAndLock(fname, 1, true);
            int imageSize = state.length();
            if (fd == null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_18", new Object[]{fname});
                }
                return false;
            }
            FileOutputStream ofile = null;
            if (imageSize > 0) {
                try {
                    ofile = new FileOutputStream(fd);
                    ofile.write(state.buffer(), 0, imageSize);
                    if (this.synchronousWrites()) {
                        ofile.flush();
                        FileDescriptor fileDesc = ofile.getFD();
                        fileDesc.sync();
                    }
                }
                catch (SyncFailedException e) {
                    this.closeAndUnlock(fd, null, ofile);
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed to sync for " + fname);
                }
                catch (FileNotFoundException e) {
                    this.closeAndUnlock(fd, null, ofile);
                    e.printStackTrace();
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed to locate file " + fname + ": " + e);
                }
                catch (IOException e) {
                    this.closeAndUnlock(fd, null, ofile);
                    e.printStackTrace();
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed for " + fname + ": " + e);
                }
            }
            if (!this.closeAndUnlock(fd, null, ofile) && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_19", new Object[]{fname});
            }
            super.addToCache(fname);
            return true;
        }
        throw new ObjectStoreException("ShadowStore::write_state - " + tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.notypenameuid") + objUid);
    }

    protected ShadowingStore(String locationOfStore) {
        this(locationOfStore, 14);
    }

    protected ShadowingStore(String locationOfStore, int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 16L, "ShadowingStore.ShadowingStore(" + locationOfStore + ")");
        }
        try {
            this.setupStore(locationOfStore);
        }
        catch (ObjectStoreException e) {
            tsLogger.arjLogger.fatal(e.getMessage());
            throw new FatalError(e.toString());
        }
    }

    protected ShadowingStore() {
        this(14);
    }

    protected ShadowingStore(int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 16L, "ShadowingStore.ShadowingStore( " + shareStatus + " )");
        }
    }

    protected ShadowingStore(ObjectName objName) {
        super(objName);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 16L, "ShadowingStore.ShadowingStore( " + objName + " )");
        }
    }
}

