/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ZipUtil {
    public static final char ZIP_PATH_DELIMITER = '!';

    public static boolean isZipFile(ZipEntry entry) {
        String name = entry.getName();
        return ZipUtil.isZipFile(name);
    }

    public static boolean isZipFile(String name) {
        return name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".sar") || name.endsWith(".rar") || name.endsWith(".ear") || name.endsWith(".aop") || name.endsWith(".esb");
    }

    public static File getExtractedZipFile(ZipFile zipFile, ZipEntry origEntry) {
        File tempFile;
        try {
            int cnt;
            String[] parentParts = zipFile.toString().split("\\\\");
            String parentZipName = parentParts[parentParts.length - 1];
            String escapedEntryName = origEntry.getName().replace("/", "-");
            String location = "from-" + escapedEntryName + "-in-" + parentZipName;
            tempFile = File.createTempFile(location, ".zip");
            InputStream orig = zipFile.getInputStream(origEntry);
            FileOutputStream fos = new FileOutputStream(tempFile);
            byte[] buffer = new byte[8192];
            while ((cnt = orig.read(buffer)) != -1) {
                fos.write(buffer, 0, cnt);
            }
            fos.close();
            orig.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error extracting inner zip file", e);
        }
        return tempFile;
    }

    public static ZipFile openFile(File file) {
        ZipFile zipFile;
        try {
            FileInputStream stream = new FileInputStream(file);
            stream.close();
            if (!file.exists()) {
                throw new FileNotFoundException("Could not find: " + file);
            }
            zipFile = new ZipFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error opening zip file:" + file, e);
        }
        return zipFile;
    }
}

