AntBuilder ant=new AntBuilder()
Binding binding = new Binding(this.binding.variables)
GroovyShell gs = new GroovyShell(binding)
components = project.properties['components'].split(",") 
scanner = ant.fileScanner
{
    fileset(dir:project.basedir)
    {
        include(name:'src/main/patches/**/*.xml')
        include(name:'src/main/patches/**/*.groovy')
        components.each 
        { 
            include(name:'src/main/common/patches/' + it + '/*.xml') 
            include(name:'src/main/common/patches/' + it + '/*.groovy')
        }
    }
}  
for(patchFile in scanner)
{
    println "patch:"+patchFile
    if(patchFile.name.endsWith(".xml"))
    {
        ant.ant(antfile:patchFile, target:"apply.patch")
        {
            property(name:"project.version", value:project.version)
            for(prop in project.properties)
            {
                property(name:prop.key, value:prop.value)
            }
        }
    }
    else if(patchFile.name.endsWith(".groovy"))
    {
        gs.evaluate(patchFile)
    }
}

