/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jboss.soa.distdiff.Addition;
import org.jboss.soa.distdiff.Delta;
import org.jboss.soa.distdiff.DirectoryComparator;
import org.jboss.soa.distdiff.ExpectedList;
import org.jboss.soa.distdiff.Mask;
import org.jboss.soa.distdiff.MaskList;
import org.jboss.soa.distdiff.Modification;
import org.jboss.soa.distdiff.Removal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistDiff
extends Task {
    private boolean detailed = true;
    private File origDir = null;
    private File newDir = null;
    private MaskList includes = new MaskList();
    private MaskList excludes = new MaskList();
    private ExpectedList expected = new ExpectedList();
    private String failFlag = null;
    private EvalScript evalScript = null;

    public void setFailFlag(String failFlag) {
        this.failFlag = failFlag;
    }

    public void setOriginal(File dir) {
        this.origDir = dir;
    }

    public void setNew(File dir) {
        this.newDir = dir;
    }

    public void setESB(File dir) {
        this.origDir = dir;
    }

    public void setSOA(File dir) {
        this.newDir = dir;
    }

    public MaskList createIncludes() {
        return this.includes;
    }

    public MaskList createExcludes() {
        return this.excludes;
    }

    public EvalScript createEvalScript() {
        this.evalScript = new EvalScript();
        return this.evalScript;
    }

    public ExpectedList createExpected() {
        return this.expected;
    }

    public boolean skipFile(String parent, String name) {
        boolean skip = false;
        if (this.getIncludes().getList().size() > 0) {
            skip = true;
            for (Mask m : this.getIncludes().getList()) {
                if (!m.getPattern().matcher(parent + name).matches()) continue;
                skip = false;
                break;
            }
        }
        if (!skip) {
            for (Mask m : this.getExcludes().getList()) {
                if (!m.getPattern().matcher(parent + name).matches()) continue;
                return true;
            }
        }
        return skip;
    }

    public void execute() throws BuildException {
        boolean failed;
        DirectoryComparator comparator = new DirectoryComparator(this);
        List<Delta> changes = comparator.getChanges(this.newDir, this.origDir);
        ArrayList<Addition> added = new ArrayList<Addition>();
        ArrayList<Removal> removed = new ArrayList<Removal>();
        ArrayList<Modification> modified = new ArrayList<Modification>();
        ArrayList<Addition> unexpectedAdded = new ArrayList<Addition>();
        ArrayList<Removal> unexpectedRemoved = new ArrayList<Removal>();
        ArrayList<Modification> unexpectedModified = new ArrayList<Modification>();
        ArrayList<Addition> misexpectedAdded = new ArrayList<Addition>();
        ArrayList<Removal> misexpectedRemoved = new ArrayList<Removal>();
        ArrayList<Modification> misexpectedModified = new ArrayList<Modification>();
        for (Delta d : this.expected.changes) {
            if (d instanceof Addition) {
                misexpectedAdded.add((Addition)d);
                continue;
            }
            if (d instanceof Removal) {
                misexpectedRemoved.add((Removal)d);
                continue;
            }
            if (!(d instanceof Modification)) continue;
            misexpectedModified.add((Modification)d);
        }
        for (Delta d : changes) {
            if (d instanceof Addition) {
                added.add((Addition)d);
                if (!this.expected.getChanges().contains(d)) {
                    unexpectedAdded.add((Addition)d);
                }
                misexpectedAdded.remove(d);
                continue;
            }
            if (d instanceof Removal) {
                removed.add((Removal)d);
                if (!this.expected.getChanges().contains(d)) {
                    unexpectedRemoved.add((Removal)d);
                }
                misexpectedRemoved.remove(d);
                continue;
            }
            if (!(d instanceof Modification)) continue;
            modified.add((Modification)d);
            if (!this.expected.getChanges().contains(d)) {
                unexpectedModified.add((Modification)d);
            }
            misexpectedModified.remove(d);
        }
        try {
            this.log("Original dir: " + this.origDir.getCanonicalPath());
            this.log("New dir: " + this.newDir.getCanonicalPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.log("================================================================================");
        this.log("Differences found");
        this.printDiffs("Additions", added, false);
        this.printDiffs("Removals", removed, false);
        this.printDiffs("Modifications", modified, false);
        this.log("================================================================================");
        this.log("================================================================================");
        this.log("Unexpected differences found");
        this.printDiffs("Additions", unexpectedAdded, false);
        this.printDiffs("Removals", unexpectedRemoved, false);
        this.printDiffs("Modifications", unexpectedModified, false);
        this.log("================================================================================");
        this.log("================================================================================");
        this.log("Expected differences not found");
        this.printDiffs("Additions", misexpectedAdded, false);
        this.printDiffs("Removals", misexpectedRemoved, false);
        this.printDiffs("Modifications", misexpectedModified, false);
        this.log("================================================================================");
        HashSet<Delta> set = new HashSet<Delta>();
        set.addAll(changes);
        boolean bl = failed = !((Object)this.expected.getChanges()).equals(set);
        if (this.evalScript != null && this.evalScript.getScript() != null) {
            try {
                Binding binding = new Binding();
                binding.setVariable("failed", (Object)failed);
                binding.setVariable("task", (Object)this);
                binding.setVariable("unexpectedAdded", unexpectedAdded);
                long size = 0L;
                for (Addition addition : unexpectedAdded) {
                    size += addition.getSize();
                }
                binding.setVariable("unexpectedAddedTotalSize", (Object)size);
                binding.setVariable("unexpectedRemoved", unexpectedRemoved);
                size = 0L;
                for (Removal removal : unexpectedRemoved) {
                    size += removal.getSize();
                }
                binding.setVariable("unexpectedRemovedTotalSize", (Object)size);
                binding.setVariable("unexpectedModified", unexpectedModified);
                binding.setVariable("expected", this.expected.getChanges());
                binding.setVariable("misexpectedAdded", misexpectedAdded);
                binding.setVariable("misexpectedRemoved", misexpectedRemoved);
                binding.setVariable("misexpectedModified", misexpectedModified);
                binding.setVariable("added", added);
                binding.setVariable("removed", removed);
                binding.setVariable("modified", modified);
                GroovyShell shell = new GroovyShell(binding);
                Object object = shell.evaluate(this.evalScript.getScript());
                if (object == null || !(object instanceof Boolean)) {
                    failed = true;
                    this.log("Invalid eval script return value '" + object + "'", 0);
                }
                failed = (Boolean)object;
            }
            catch (CompilationFailedException e) {
                failed = true;
                this.log("Error in eval script compilation '" + e.toString() + "'", 0);
                e.printStackTrace();
            }
        }
        if (failed) {
            String msg = "Unexpected differences were found or expected differences were not found";
            if (this.failFlag == null) {
                throw new BuildException(msg);
            }
            this.log(msg, 0);
            this.getProject().setProperty(this.failFlag, "true");
        }
    }

    private void printDiffs(String type, List<? extends Delta> list, boolean printsize) {
        this.log("\t" + type);
        for (Delta delta : list) {
            StringBuilder sb = new StringBuilder();
            sb.append("\t\t" + delta.getRelativePath());
            if (printsize) {
                sb.append(" size: ");
                sb.append(delta.getSize());
            }
            if (this.expected.getChanges().contains(delta)) {
                sb.append(" (expected)");
            }
            this.log(sb.toString());
        }
        if (list.size() == 0) {
            this.log("None");
        }
    }

    public MaskList getIncludes() {
        return this.includes;
    }

    public MaskList getExcludes() {
        return this.excludes;
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public static class EvalScript {
        private String script;

        public void addText(String script) {
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }
    }
}

