/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jboss.soa.distdiff.Addition;
import org.jboss.soa.distdiff.Delta;
import org.jboss.soa.distdiff.DistDiff;
import org.jboss.soa.distdiff.Modification;
import org.jboss.soa.distdiff.Removal;
import org.jboss.soa.distdiff.ZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipComparator {
    private DistDiff task;

    public ZipComparator(DistDiff task) {
        this.task = task;
    }

    public List<Delta> compare(File newZip, File origZip, String parent) {
        ZipFile newZipFile = ZipUtil.openFile(newZip);
        ZipFile origZipFile = ZipUtil.openFile(origZip);
        List<Delta> differences = this.getNewFiles(newZipFile, origZipFile, parent);
        Enumeration entries = origZipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipEntry origEntry = (ZipEntry)entries.nextElement();
            ZipEntry newEntry = this.findEntry(newZipFile, origEntry);
            if (newEntry == null) {
                differences.add(new Removal(parent + origEntry.getName(), 0L));
                continue;
            }
            String name = origEntry.getName();
            if (this.task.skipFile(parent, name)) {
                this.task.log("Skipping file " + parent + name);
                continue;
            }
            if (origEntry.getCrc() == newEntry.getCrc()) continue;
            if (ZipUtil.isZipFile(origEntry)) {
                File origInnerZip = ZipUtil.getExtractedZipFile(origZipFile, origEntry);
                File newInnerZip = ZipUtil.getExtractedZipFile(newZipFile, newEntry);
                differences.addAll(this.compare(newInnerZip, origInnerZip, parent + origEntry.getName() + '!'));
                continue;
            }
            differences.add(new Modification(parent + origEntry.getName()));
        }
        try {
            newZipFile.close();
            origZipFile.close();
        }
        catch (IOException e) {
            this.task.log(e.toString(), 0);
            e.printStackTrace();
        }
        return differences;
    }

    private ZipEntry findEntry(ZipFile zipFile, ZipEntry entryToFind) {
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            if (!entry.getName().equals(entryToFind.getName())) continue;
            return entry;
        }
        return null;
    }

    private List<Delta> getNewFiles(ZipFile newZipFile, ZipFile origZipFile, String parent) {
        HashSet<String> differences = new HashSet<String>();
        Enumeration newEntries = newZipFile.getEntries();
        while (newEntries.hasMoreElements()) {
            differences.add(((ZipEntry)newEntries.nextElement()).getName());
        }
        Enumeration origEntries = origZipFile.getEntries();
        while (origEntries.hasMoreElements()) {
            differences.remove(((ZipEntry)origEntries.nextElement()).getName());
        }
        ArrayList<Delta> deltas = new ArrayList<Delta>();
        for (String difference : differences) {
            deltas.add(new Addition(parent + difference, 0L));
        }
        return deltas;
    }
}

