// SA-1100 Definitions used in map1100.h and other OAL assembler files

#define CACHED_TO_UNCACHED_OFFSET		0x20000000

#define PCMCIA_S0_IO_PHYSICAL			0x20000000
#define PCMCIA_S0_IO_C_VIRTUAL			0x8BA00000
#define PCMCIA_S0_IO_U_VIRTUAL			(PCMCIA_S0_IO_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define PCMCIA_S1_IO_PHYSICAL			0x30000000
#define PCMCIA_S1_IO_C_VIRTUAL			0x8BC00000
#define PCMCIA_S1_IO_U_VIRTUAL			(PCMCIA_S1_IO_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define PCMCIA_S0_ATTR_PHYSICAL			0x28000000
#define PCMCIA_S0_ATTR_C_VIRTUAL		0x90000000
#define PCMCIA_S0_ATTR_U_VIRTUAL		(PCMCIA_S0_ATTR_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define PCMCIA_S1_ATTR_PHYSICAL			0x38000000
#define PCMCIA_S1_ATTR_C_VIRTUAL		0x94400000
#define PCMCIA_S1_ATTR_U_VIRTUAL		(PCMCIA_S1_ATTR_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define PCMCIA_S0_CMN_PHYSICAL			0x2C000000
#define PCMCIA_S0_CMN_C_VIRTUAL			0x94C00000
#define PCMCIA_S0_CMN_U_VIRTUAL			(PCMCIA_S0_CMN_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define PCMCIA_S1_CMN_PHYSICAL			0x3C000000
#define PCMCIA_S1_CMN_C_VIRTUAL			0x98C00000	// cached virtual
#define PCMCIA_S1_CMN_U_VIRTUAL			(PCMCIA_S1_CMN_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define DMA_BASE_PHYSICAL			0xB0000000
#define DMA_BASE_C_VIRTUAL			0x8B000000	// cached virtual
#define DMA_BASE_U_VIRTUAL			(DMA_BASE_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define SC_BASE_PHYSICAL			0x90000000
#define SC_BASE_C_VIRTUAL			0x89000000	// cached virtual
#define SC_BASE_U_VIRTUAL			(SC_BASE_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define SER_BASE_PHYSICAL			0x80000000
#define SER_BASE_C_VIRTUAL			0x88000000	// cached virtual
#define SER_BASE_U_VIRTUAL			(SER_BASE_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define MEMC_BASE_PHYSICAL			0xA0000000
#define MEMC_BASE_C_VIRTUAL			0x8A000000	// cached virtual
#define MEMC_BASE_U_VIRTUAL			(MEMC_BASE_C_VIRTUAL+CACHED_TO_UNCACHED_OFFSET)

#define ZBANK_BASE_PHYSICAL			0xE0000000
#define ZBANK_BASE_C_VIRTUAL			0x88C00000	// cached virtual
#define ZBANK_BASE_U_VIRTUAL			0x88D00000	// cached virtual, unbuffered

// SA-1100 Registers 

#define UART_3_OFFSET			0x50000
#define UT_BASE_PHYSICAL			(SER_BASE_PHYSICAL+UART_3_OFFSET)
#define UTCR0_PHYSICAL			(UT_BASE_PHYSICAL)
#define UTCR1_PHYSICAL			(UT_BASE_PHYSICAL+0x4)
#define UTCR2_PHYSICAL			(UT_BASE_PHYSICAL+0x8)
#define UTCR3_PHYSICAL			(UT_BASE_PHYSICAL+0xC)
#define UTSR0_PHYSICAL			(UT_BASE_PHYSICAL+0x1C)

#define UT_BASE_VIRTUAL			(SER_BASE_U_VIRTUAL+UART_3_OFFSET)
#define UTCR0_VIRTUAL			(UT_BASE_VIRTUAL)
#define UTCR1_VIRTUAL			(UT_BASE_VIRTUAL+0x4)
#define UTCR2_VIRTUAL			(UT_BASE_VIRTUAL+0x8)
#define UTCR3_VIRTUAL			(UT_BASE_VIRTUAL+0xC)
#define UTSR0_VIRTUAL			(UT_BASE_VIRTUAL+0x1C)

#define MCP_OFFSET				0x60000
#define MCP_BASE_PHYSICAL			(SER_BASE_PHYSICAL+MCP_OFFSET)
#define MCCR_PHYSICAL			(MCP_BASE_PHYSICAL)
#define MCPDR2_PHYSICAL			(MCP_BASE_PHYSICAL+0x10)
#define MCSR_PHYSICAL			(MCP_BASE_PHYSICAL+0x18)

#define MCP_BASE_VIRTUAL			(SER_BASE_U_VIRTUAL+MCP_OFFSET)
#define MCCR_VIRTUAL			(MCP_BASE_VIRTUAL)
#define MCPDR2_VIRTUAL			(MCP_BASE_VIRTUAL+0x10)
#define MCSR_VIRTUAL			(MCP_BASE_VIRTUAL+0x18)
  
#define OC_BASE_PHYSICAL			(SC_BASE_PHYSICAL)
#define OSMR0_PHYSICAL			(OC_BASE_PHYSICAL)
#define OSMR1_PHYSICAL			(OC_BASE_PHYSICAL+0x4)
#define OSMR2_PHYSICAL			(OC_BASE_PHYSICAL+0x8)
#define OSMR3_PHYSICAL			(OC_BASE_PHYSICAL+0xC)
#define OSCR_PHYSICAL			(OC_BASE_PHYSICAL+0x10)
#define OWER_PHYSICAL			(OC_BASE_PHYSICAL+0x18)
#define OSSR_PHYSICAL			(OC_BASE_PHYSICAL+0x14)
#define OIER_PHYSICAL			(OC_BASE_PHYSICAL+0x1C)

#define OC_BASE_VIRTUAL			(SC_BASE_U_VIRTUAL)
#define OSMR0_VIRTUAL			(OC_BASE_VIRTUAL)
#define OSMR1_VIRTUAL			(OC_BASE_VIRTUAL+0x4)
#define OSMR2_VIRTUAL			(OC_BASE_VIRTUAL+0x8)
#define OSMR3_VIRTUAL			(OC_BASE_VIRTUAL+0xC)
#define OSCR_VIRTUAL			(OC_BASE_VIRTUAL+0x10)
#define OWER_VIRTUAL			(OC_BASE_VIRTUAL+0x18)
#define OSSR_VIRTUAL			(OC_BASE_VIRTUAL+0x14)
#define OIER_VIRTUAL			(OC_BASE_VIRTUAL+0x1C)

//#define RTC_OFFSET					0x10000
#define RTC_BASE_PHYSICAL		(SC_BASE_PHYSICAL+RTC_OFFSET)
#define RTAR_PHYSICAL			(RTC_BASE_PHYSICAL)
#define RCNR_PHYSICAL			(RTC_BASE_PHYSICAL+0x4)
#define RTTR_PHYSICAL			(RTC_BASE_PHYSICAL+0x8)
#define RTSR_PHYSICAL			(RTC_BASE_PHYSICAL+0x10)

#define RTC_BASE_VIRTUAL			(SC_BASE_U_VIRTUAL+RTC_OFFSET)
#define RTAR_VIRTUAL			(RTC_BASE_VIRTUAL)
#define RCNR_VIRTUAL			(RTC_BASE_VIRTUAL+0x4)
#define RTTR_VIRTUAL			(RTC_BASE_VIRTUAL+0x8)
#define RTSR_VIRTUAL			(RTC_BASE_VIRTUAL+0x10)

#define PMC_OFFSET				0x20000
#define PMC_BASE_PHYSICAL			(SC_BASE_PHYSICAL+PMC_OFFSET)
#define PMCR_PHYSICAL			(PMC_BASE_PHYSICAL)
#define PSSR_PHYSICAL			(PMC_BASE_PHYSICAL+0x4)
#define PSPR_PHYSICAL			(PMC_BASE_PHYSICAL+0x8)
#define PWER_PHYSICAL			(PMC_BASE_PHYSICAL+0xC)
#define PCFR_PHYSICAL			(PMC_BASE_PHYSICAL+0x10)
#define PPCR_PHYSICAL			(PMC_BASE_PHYSICAL+0x14)
#define PGSR_PHYSICAL			(PMC_BASE_PHYSICAL+0x18)

#define PMC_BASE_VIRTUAL			(SC_BASE_U_VIRTUAL+PMC_OFFSET)
#define PMCR_VIRTUAL			(PMC_BASE_VIRTUAL)
#define PSSR_VIRTUAL			(PMC_BASE_VIRTUAL+0x4)
#define PSPR_VIRTUAL			(PMC_BASE_VIRTUAL+0x8)
#define PWER_VIRTUAL			(PMC_BASE_VIRTUAL+0xC)
#define PCFR_VIRTUAL			(PMC_BASE_VIRTUAL+0x10)
#define PPCR_VIRTUAL			(PMC_BASE_VIRTUAL+0x14)
#define PGSR_VIRTUAL			(PMC_BASE_VIRTUAL+0x18)

#define RC_OFFSET				(0x30000)
#define RC_BASE_PHYSICAL			(SC_BASE_PHYSICAL+RC_OFFSET)
#define RCSR_PHYSICAL			(RC_BASE_PHYSICAL+0x4)
#define TUCR_PHYSICAL			(RC_BASE_PHYSICAL+0x8)

#define RC_BASE_VIRTUAL			(SC_BASE_U_VIRTUAL+RC_OFFSET)
#define RCSR_VIRTUAL			(RC_BASE_VIRTUAL+0x4)
#define TUCR_VIRTUAL			(RC_BASE_VIRTUAL+0x8)

#define GP_OFFSET				(0x40000)
#define GP_BASE_PHYSICAL			(SC_BASE_PHYSICAL+GP_OFFSET)
#define GPLR_PHYSICAL			(GP_BASE_PHYSICAL)
#define GPDR_PHYSICAL			(GP_BASE_PHYSICAL+0x4)
#define GPSR_PHYSICAL			(GP_BASE_PHYSICAL+0x8)
#define GPCR_PHYSICAL			(GP_BASE_PHYSICAL+0xC)
#define GRER_PHYSICAL			(GP_BASE_PHYSICAL+0x10)
#define GFER_PHYSICAL			(GP_BASE_PHYSICAL+0x14)
#define GEDR_PHYSICAL			(GP_BASE_PHYSICAL+0x18)
#define GAFR_PHYSICAL			(GP_BASE_PHYSICAL+0x1C)

#define GP_BASE_VIRTUAL			(SC_BASE_U_VIRTUAL+GP_OFFSET)
#define GPLR_VIRTUAL			(GP_BASE_VIRTUAL)
#define GPDR_VIRTUAL			(GP_BASE_VIRTUAL+0x4)
#define GPSR_VIRTUAL			(GP_BASE_VIRTUAL+0x8)
#define GPCR_VIRTUAL			(GP_BASE_VIRTUAL+0xC)
#define GRER_VIRTUAL			(GP_BASE_VIRTUAL+0x10)
#define GFER_VIRTUAL			(GP_BASE_VIRTUAL+0x14)
#define GEDR_VIRTUAL			(GP_BASE_VIRTUAL+0x18)
#define GAFR_VIRTUAL			(GP_BASE_VIRTUAL+0x1C)

#define IC_OFFSET				(0x50000)
#define IC_BASE_PHYSICAL			(SC_BASE_PHYSICAL+IC_OFFSET)
#define ICIP_PHYSICAL			(IC_BASE_PHYSICAL)
#define ICMR_PHYSICAL			(IC_BASE_PHYSICAL+0x4)
#define ICLR_PHYSICAL			(IC_BASE_PHYSICAL+0x8)
#define ICCR_PHYSICAL			(IC_BASE_PHYSICAL+0xC)
#define ICFP_PHYSICAL			(IC_BASE_PHYSICAL+0x10)
#define ICPR_PHYSICAL			(IC_BASE_PHYSICAL+0x20)

#define IC_BASE_VIRTUAL			(SC_BASE_U_VIRTUAL+IC_OFFSET)
#define ICIP_VIRTUAL			(IC_BASE_VIRTUAL)
#define ICMR_VIRTUAL			(IC_BASE_VIRTUAL+0x4)
#define ICLR_VIRTUAL			(IC_BASE_VIRTUAL+0x8)
#define ICCR_VIRTUAL			(IC_BASE_VIRTUAL+0xC)
#define ICFP_VIRTUAL			(IC_BASE_VIRTUAL+0x10)
#define ICPR_VIRTUAL			(IC_BASE_VIRTUAL+0x20)

#define PP_OFFSET				(0x60000)
#define PPC_BASE_PHYSICAL			(SC_BASE_PHYSICAL+PP_OFFSET)
#define PPDR_PHYSICAL			(PPC_BASE_PHYSICAL)
#define PPSR_PHYSICAL			(PPC_BASE_PHYSICAL+0x4)
#define PPAR_PHYSICAL			(PPC_BASE_PHYSICAL+0x8)
#define PSDR_PHYSICAL			(PPC_BASE_PHYSICAL+0xC)
#define PPFR_PHYSICAL			(PPC_BASE_PHYSICAL+0x10)
#define MCCR1_PHYSICAL			(PPC_BASE_PHYSICAL+0x30)

#define PPC_BASE_VIRTUAL			(SC_BASE_U_VIRTUAL+PP_OFFSET)
#define PPDR_VIRTUAL			(PPC_BASE_VIRTUAL)
#define PPSR_VIRTUAL			(PPC_BASE_VIRTUAL+0x4)
#define PPAR_VIRTUAL			(PPC_BASE_VIRTUAL+0x8)
#define PSDR_VIRTUAL			(PPC_BASE_VIRTUAL+0xC)
#define PPFR_VIRTUAL			(PPC_BASE_VIRTUAL+0x10)
#define MCCR1_VIRTUAL			(PPC_BASE_VIRTUAL+0x30)

#define MC_BASE_PHYSICAL			(MEMC_BASE_PHYSICAL)
#define MDCNFG_PHYSICAL			(MC_BASE_PHYSICAL)
#define MDCAS00_PHYSICAL			(MC_BASE_PHYSICAL+0x4) 
#define MDCAS01_PHYSICAL 			(MC_BASE_PHYSICAL+0x8)
#define MDCAS02_PHYSICAL			(MC_BASE_PHYSICAL+0xC) 
#define MSC0_PHYSICAL 			(MC_BASE_PHYSICAL+0x10)
#define MSC1_PHYSICAL			(MC_BASE_PHYSICAL+0x14)
#define MECR_PHYSICAL			(MC_BASE_PHYSICAL+0x18)
#define MDRERF_PHYSICAL			(MC_BASE_PHYSICAL+0x1C)
#define MDCAS20_PHYSICAL			(MC_BASE_PHYSICAL+0x20) 
#define MDCAS21_PHYSICAL 			(MC_BASE_PHYSICAL+0x24)
#define MDCAS22_PHYSICAL			(MC_BASE_PHYSICAL+0x28)
#define MSC2_PHYSICAL			(MC_BASE_PHYSICAL+0x2C)
#define SMCNFG_PHYSICAL			(MC_BASE_PHYSICAL+0x30)

#define MC_BASE_VIRTUAL			(MEMC_BASE_U_VIRTUAL)
#define MDCNFG_VIRTUAL			(MC_BASE_VIRTUAL)
#define MDCAS00_VIRTUAL			(MC_BASE_VIRTUAL+0x4) 
#define MDCAS01_VIRTUAL 			(MC_BASE_VIRTUAL+0x8)
#define MDCAS02_VIRTUAL			(MC_BASE_VIRTUAL+0xC)
#define MSC0_VIRTUAL 			(MC_BASE_VIRTUAL+0x10)
#define MSC1_VIRTUAL			(MC_BASE_VIRTUAL+0x14)
#define MECR_VIRTUAL			(MC_BASE_VIRTUAL+0x18)
#define MDRERF_VIRTUAL			(MC_BASE_VIRTUAL+0x1C)
#define MDCAS20_VIRTUAL			(MC_BASE_VIRTUAL+0x20) 
#define MDCAS21_VIRTUAL 			(MC_BASE_VIRTUAL+0x24)
#define MDCAS22_VIRTUAL			(MC_BASE_VIRTUAL+0x28)
#define MSC2_VIRTUAL			(MC_BASE_VIRTUAL+0x2C)
#define SMCNFG_VIRTUAL			(MC_BASE_VIRTUAL+0x30)

#define LCD_OFFSET				0x100000
#define LCD_BASE_PHYSICAL			(DMA_BASE_PHYSICAL+LCD_OFFSET)
#define LCCR0_PHYSICAL			(LCD_BASE_PHYSICAL)
#define LCSR_PHYSICAL			(LCD_BASE_PHYSICAL+0x4)
#define DBAR1_PHYSICAL			(LCD_BASE_PHYSICAL+0x10)
#define DCAR1_PHYSICAL			(LCD_BASE_PHYSICAL+0x14)
#define DBAR2_PHYSICAL			(LCD_BASE_PHYSICAL+0x18)
#define DCAR2_PHYSICAL			(LCD_BASE_PHYSICAL+0x1C)
#define LCCR1_PHYSICAL			(LCD_BASE_PHYSICAL+0x20)
#define LCCR2_PHYSICAL			(LCD_BASE_PHYSICAL+0x24)
#define LCCR3_PHYSICAL 			(LCD_BASE_PHYSICAL+0x28)

#define LCD_BASE_VIRTUAL			(DMA_BASE_U_VIRTUAL+LCD_OFFSET)
#define LCCR0_VIRTUAL			(LCD_BASE_VIRTUAL)
#define LCSR_VIRTUAL			(LCD_BASE_VIRTUAL+0x4)
#define DBAR1_VIRTUAL			(LCD_BASE_VIRTUAL+0x10)
#define DCAR1_VIRTUAL			(LCD_BASE_VIRTUAL+0x14)
#define DBAR2_VIRTUAL			(LCD_BASE_VIRTUAL+0x18)
#define DCAR2_VIRTUAL			(LCD_BASE_VIRTUAL+0x1C)
#define LCCR1_VIRTUAL			(LCD_BASE_VIRTUAL+0x20)
#define LCCR2_VIRTUAL			(LCD_BASE_VIRTUAL+0x24)
#define LCCR3_VIRTUAL 			(LCD_BASE_VIRTUAL+0x28)

#define SLEEPDATABLOCK_PHYSICAL 	0xC0058000		// Must sync with SLEEP_SAV in FILES\config.bib and EBOOT\ARM\eboot.bib
#define SLEEPDATABLOCK_VIRTUAL 		0xAC058000		// Must reflect map1100.h mapping of SLEEP_SAV area

// Register bit definitions
#define RTC_AL  		  	0x00000001 
#define RTC_HZ    			0x00000002
#define OSSR_M_M0 			0x00000001
#define OSSR_M_M1 			0x00000002 
#define OSSR_M_M2 			0x00000004
#define OSSR_M_M3 			0x00000008
#define PMCR_SLEEP  	  	0x00000001
#define PCFR_OPDE   	  	0x00000001
#define PCFR_FO  		  	0x00000008
#define PSSR_DRH			0x00000008
#define PSSR_PRH			0x00000010

#define RCSR_SLEEP_MODE		0x8
#define RCSR_HARD_RESET		0x1	
#define RCSR_CLEAR			0x7

#define GAFR_DCCLOCK		0x08000000
#define GAFR_MBREQMBGNT		0x00600000
#define GAFR_LDD			0x000003FC
#define GAFR_SSP_TXD		0x00000400
#define GAFR_SSP_RXD		0x00000800
#define GAFR_SSP_SCLK		0x00001000
#define GAFR_SSP_FRM		0x00002000
#define GAFR_UART_TXD		0x00004000
#define GAFR_UART_RXD		0x00008000
#define GAFR_SDLC_SCLK		0x00010000
#define GAFR_SDLC_AAF		0x00020000
#define GAFR_UART_SCLK1		0x00040000
#define GAFR_SSP_CLK		0x00080000
#define GAFR_UART_SCLK3		0x00100000
#define GAFR_MCP_CLK		0x00200000
#define GAFR_TIC_ACK_MBGNT		0x00200000
#define GAFR_TREQA_MBREQ		0x00400000
#define GAFR_TREQB			0x00800000
#define GAFR_RSVD			0x01000000
#define GAFR_TDC_clock		0x02000000
#define GAFR_RCLK_OUT		0x04000000
#define GAFR_32KHZ_OUT		0x08000000

#define Mode_USR		   0x10
#define Mode_FIQ			0x11
#define Mode_IRQ		   0x12
#define Mode_SVC		   0x13
#define Mode_ABT		   0x17
#define Mode_UND		   0x1B
#define Mode_SYS			0x1F

#define SLEEP_MODE_BIT		0x8
#define HARD_RESET_BIT		0x1	

#define INIT_MMU			0x00001272
#define I_Bit           	   0x80
#define F_Bit           	   0x40
#define MMU_CTRL_MASK		0xFFFFCC00
#define MMU_TTB_MASK		0x00003FFF

#define RTC_ALM 		0x80000000
#define HZ_TIC		0x40000000
#define OS_TIMER3		0x20000000
#define OS_TIMER2		0x10000000
#define OS_TIMER1		0x08000000
#define OS_TIMER0		0x04000000
#define IC_DMA_CH5		0x02000000
#define IC_DMA_CH4		0x01000000
#define IC_DMA_CH3		0x00800000
#define IC_DMA_CH2		0x00400000
#define IC_DMA_CH1		0x00200000
#define IC_DMA_CH0		0x00100000
#define SERIAL_4B	 	0x00080000  // SSP
#define SERIAL_4A   	0x00040000  // MCP
#define SERIAL_3	 	0x00020000  // UART
#define SERIAL_2    	0x00010000  // HSSP/UART
#define SERIAL_1B   	0x00008000  // UART Interrupt
#define SERIAL_1A   	0x00004000  // SDLC Interrupt
#define SERIAL_0    	0x00002000  // UDC 
#define LCD_CTRL    	0x00001000
#define GPIO_GRP    	0x00000800
#define GPIO_10     	0x00000400
#define GPIO_9      	0x00000200
#define GPIO_8      	0x00000100
#define GPIO_7      	0x00000080
#define GPIO_6      	0x00000040
#define GPIO_5      	0x00000020
#define GPIO_4      	0x00000010
#define GPIO_3      	0x00000008
#define GPIO_2      	0x00000004
#define GPIO_1      	0x00000002
#define GPIO_0		0x00000001
//SA_1101		 (1<<11)	//SideKick for Level Register
#define AUDIO_INTERRUPT        	 0x03000000

