long udivmodsi4 (unsigned long, unsigned long, char);
int  udivmodhi4 (unsigned int, unsigned int, char);

long _divsi3 (long, long);
long _modsi3 (long, long);

int _divhi3 (int, int);
int _modhi3 (int, int);

long
_divsi3 (long a, long b)
{
  char neg = 0;
  long res;

  if (a < 0)
    {
      a = -a;
      neg = !neg;
    }

  if (b < 0)
    {
      b = -b;
      neg = !neg;
    }

  res = udivmodsi4 (a, b, 0);

  if (neg)
    res = -res;

  return res;
}

long
_modsi3 (long a, long b)
{
  char neg = 0;
  long res;

  if (a < 0)
    {
      a = -a;
      neg = 1;
    }

  if (b < 0)
    b = -b;

  res = udivmodsi4 (a, b, 1);

  if (neg)
    res = -res;

  return res;
}

int
_divhi3 (int a, int b)
{
  char neg = 0;
  int res;

  if (a < 0)
    {
      a = -a;
      neg = !neg;
    }

  if (b < 0)
    {
      b = -b;
      neg = !neg;
    }

  res = udivmodhi4 (a, b, 0);

  if (neg)
    res = -res;

  return res;
}

int
_modhi3 (int a, int b)
{
  char neg = 0;
  int res;

  if (a < 0)
    {
      a = -a;
      neg = 1;
    }

  if (b < 0)
    b = -b;

  res = udivmodhi4 (a, b, 1);

  if (neg)
    res = -res;

  return res;
}
