/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.xa;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.xa.XID;
import com.arjuna.ats.internal.arjuna.utils.XATxConverter;
import com.arjuna.ats.jta.logging.jtaLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImple
implements Xid,
Serializable {
    private static final long serialVersionUID = -8922505475867377266L;
    private XID _theXid;
    private int hashCode;

    public XidImple() {
        this._theXid = null;
        this.hashCode = XidImple.getHash(this._theXid);
    }

    public XidImple(Xid xid) {
        this._theXid = null;
        this.copy(xid);
        this.hashCode = XidImple.getHash(this._theXid);
    }

    public XidImple(AtomicAction c) {
        this(c.get_uid(), false);
    }

    public XidImple(AtomicAction c, boolean branch) {
        this(c.get_uid(), branch);
    }

    public XidImple(Uid id) {
        this(id, false);
    }

    public XidImple(Uid id, boolean branch) {
        try {
            this._theXid = XATxConverter.getXid(id, branch);
        }
        catch (Exception e) {
            this._theXid = null;
        }
        this.hashCode = XidImple.getHash(this._theXid);
    }

    public XidImple(Uid id, Uid branch, int formatId) {
        try {
            this._theXid = XATxConverter.getXid(id, branch, formatId);
        }
        catch (Exception e) {
            this._theXid = null;
        }
        this.hashCode = XidImple.getHash(this._theXid);
    }

    public XidImple(XID x) {
        this._theXid = x;
        this.hashCode = XidImple.getHash(this._theXid);
    }

    public final boolean isSameTransaction(Xid xid) {
        byte[] gtx;
        if (xid == null) {
            return false;
        }
        if (xid instanceof XidImple) {
            return this._theXid.isSameTransaction(((XidImple)xid)._theXid);
        }
        if (this.getFormatId() == xid.getFormatId() && this._theXid.gtrid_length == (gtx = xid.getGlobalTransactionId()).length) {
            if (this.equals(xid)) {
                return true;
            }
            for (int i = 0; i < this._theXid.gtrid_length; ++i) {
                if (this._theXid.data[i] == gtx[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getFormatId() {
        if (this._theXid != null) {
            return this._theXid.formatID;
        }
        return -1;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        if (this._theXid != null) {
            byte[] b = new byte[this._theXid.gtrid_length];
            System.arraycopy(this._theXid.data, 0, b, 0, b.length);
            return b;
        }
        return null;
    }

    @Override
    public byte[] getBranchQualifier() {
        if (this._theXid != null) {
            byte[] b = new byte[this._theXid.bqual_length];
            System.arraycopy(this._theXid.data, this._theXid.gtrid_length, b, 0, b.length);
            return b;
        }
        return null;
    }

    public final XID getXID() {
        return this._theXid;
    }

    public final void copy(Xid xid) {
        this._theXid = new XID();
        if (xid != null) {
            if (xid instanceof XidImple) {
                this._theXid.copy(((XidImple)xid)._theXid);
            } else {
                this._theXid.formatID = xid.getFormatId();
                byte[] gtx = xid.getGlobalTransactionId();
                byte[] bql = xid.getBranchQualifier();
                int bqlength = bql == null ? 0 : bql.length;
                this._theXid.gtrid_length = gtx.length;
                this._theXid.bqual_length = bqlength;
                System.arraycopy(gtx, 0, this._theXid.data, 0, gtx.length);
                if (bqlength > 0) {
                    System.arraycopy(bql, 0, this._theXid.data, gtx.length, bql.length);
                }
            }
        }
    }

    public boolean equals(Xid xid) {
        if (xid == null) {
            return false;
        }
        if (xid == this) {
            return true;
        }
        if (xid instanceof XidImple) {
            return ((XidImple)xid)._theXid.equals(this._theXid);
        }
        if (xid.getFormatId() == this._theXid.formatID) {
            int bqlength;
            byte[] gtx = xid.getGlobalTransactionId();
            byte[] bql = xid.getBranchQualifier();
            int n = bqlength = bql == null ? 0 : bql.length;
            if (this._theXid.gtrid_length == gtx.length && this._theXid.bqual_length == bqlength) {
                int i;
                for (i = 0; i < this._theXid.gtrid_length; ++i) {
                    if (this._theXid.data[i] == gtx[i]) continue;
                    return false;
                }
                for (i = this._theXid.gtrid_length; i < this._theXid.gtrid_length + this._theXid.bqual_length; ++i) {
                    if (this._theXid.data[i] == bql[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final boolean packInto(OutputObjectState os) {
        boolean result = false;
        try {
            os.packInt(this._theXid.formatID);
            os.packInt(this._theXid.gtrid_length);
            os.packInt(this._theXid.bqual_length);
            os.packBytes(this._theXid.data);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public final boolean unpackFrom(InputObjectState os) {
        boolean result = false;
        try {
            if (this._theXid == null) {
                this._theXid = new XID();
            }
            this._theXid.formatID = os.unpackInt();
            this._theXid.gtrid_length = os.unpackInt();
            this._theXid.bqual_length = os.unpackInt();
            this._theXid.data = os.unpackBytes();
            this.hashCode = XidImple.getHash(this._theXid);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static final void pack(OutputObjectState os, Xid xid) throws IOException {
        if (xid instanceof XidImple) {
            XidImple x = (XidImple)xid;
            os.packBoolean(true);
            if (!x.packInto(os)) {
                throw new IOException(jtaLogger.logMesg.getString("com.arjuna.ats.jta.xid.packerror"));
            }
        } else {
            os.packBoolean(false);
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            ObjectOutputStream o = new ObjectOutputStream(s);
            o.writeObject(xid);
            o.close();
            os.packBytes(s.toByteArray());
        }
    }

    public static final Xid unpack(InputObjectState os) throws IOException {
        if (os.unpackBoolean()) {
            XidImple x = new XidImple();
            x.unpackFrom(os);
            return x;
        }
        try {
            byte[] b = os.unpackBytes();
            ByteArrayInputStream s = new ByteArrayInputStream(b);
            ObjectInputStream o = new ObjectInputStream(s);
            Xid x = (Xid)o.readObject();
            return x;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public String toString() {
        if (this._theXid != null) {
            return this._theXid.toString();
        }
        return jtaLogger.logMesg.getString("com.arjuna.ats.jta.xa.xidunset");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Xid) {
            return this.equals((Xid)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static int getHash(XID xid) {
        if (xid == null) {
            return 0;
        }
        int hash = XidImple.generateHash(xid.formatID, xid.data, 0, xid.gtrid_length);
        return XidImple.generateHash(hash, xid.data, xid.gtrid_length, xid.bqual_length);
    }

    private static int generateHash(int hash, byte[] bytes, int start, int length) {
        for (int count = start; count < length; ++count) {
            hash = 31 * hash + bytes[count];
        }
        return hash;
    }
}

