/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import org.jboss.jms.message.JBossObjectMessage;
import org.jboss.jms.message.MessageProxy;

public class ObjectMessageProxy
extends MessageProxy
implements ObjectMessage {
    private static final long serialVersionUID = 8797295997477962825L;
    private transient Serializable cachedObject;

    public ObjectMessageProxy(long deliveryId, JBossObjectMessage message, int deliveryCount) {
        super(deliveryId, message, deliveryCount);
    }

    public ObjectMessageProxy(JBossObjectMessage message) {
        super(message);
    }

    public ObjectMessageProxy(ObjectMessageProxy proxy) throws JMSException {
        super(proxy);
    }

    public void setObject(Serializable object) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("setObject");
        }
        this.bodyChange();
        ((ObjectMessage)this.message).setObject(object);
    }

    public Serializable getObject() throws JMSException {
        if (this.cachedObject == null) {
            this.cachedObject = ((ObjectMessage)this.message).getObject();
        }
        return this.cachedObject;
    }

    protected void bodyChange() throws JMSException {
        super.bodyChange();
        this.cachedObject = null;
    }

    public MessageProxy duplicate() throws JMSException {
        return new ObjectMessageProxy(this);
    }
}

