/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import javax.ws.rs.FormParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartFormDataWriter;
import org.jboss.resteasy.plugins.providers.multipart.FieldEnablerPrivilegedAction;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.spi.WriterException;
import org.jboss.resteasy.util.FindAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"multipart/form-data"})
public class MultipartFormAnnotationWriter
extends AbstractMultipartFormDataWriter
implements MessageBodyWriter<Object> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return FindAnnotation.findAnnotation((Annotation[])annotations, MultipartForm.class) != null || type.isAnnotationPresent(MultipartForm.class);
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MultipartFormDataOutput multipart = new MultipartFormDataOutput();
        for (Class<?> theType = type; theType != null && !theType.equals(Object.class); theType = theType.getSuperclass()) {
            this.getFields(theType, multipart, obj);
        }
        for (Method method : type.getMethods()) {
            if (!method.isAnnotationPresent(FormParam.class) || !method.getName().startsWith("get") || method.getParameterTypes().length != 0 || !method.isAnnotationPresent(PartType.class)) continue;
            FormParam param = method.getAnnotation(FormParam.class);
            Object value = null;
            try {
                value = method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new WriterException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WriterException(e.getCause());
            }
            PartType partType = method.getAnnotation(PartType.class);
            multipart.addFormData(param.value(), value, method.getReturnType(), method.getGenericReturnType(), MediaType.valueOf((String)partType.value()));
        }
        this.write(multipart, mediaType, httpHeaders, entityStream);
    }

    protected void getFields(Class<?> type, MultipartFormDataOutput output, Object obj) throws IOException {
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(FormParam.class) || !field.isAnnotationPresent(PartType.class)) continue;
            AccessController.doPrivileged(new FieldEnablerPrivilegedAction(field));
            FormParam param = field.getAnnotation(FormParam.class);
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new WriterException((Throwable)e);
            }
            PartType partType = field.getAnnotation(PartType.class);
            output.addFormData(param.value(), value, field.getType(), field.getGenericType(), MediaType.valueOf((String)partType.value()));
        }
    }
}

