/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.AnnotationMetaDataDeployer;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AnnotationMergedView;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class MergedJBossWebMetaDataDeployer
extends AbstractDeployer {
    public static final String WEB_MERGED_ATTACHMENT_NAME = "merged." + JBossWebMetaData.class.getName();

    public MergedJBossWebMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(WebMetaData.class);
        this.addInput(JBossWebMetaData.class);
        this.addInput(AnnotationMetaDataDeployer.WEB_ANNOTATED_ATTACHMENT_NAME);
        this.setOutput(JBossWebMetaData.class);
        this.addOutput(WEB_MERGED_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        WebMetaData specMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        JBossWebMetaData metaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (specMetaData == null && metaData == null) {
            return;
        }
        String key = AnnotationMetaDataDeployer.WEB_ANNOTATED_ATTACHMENT_NAME;
        Web25MetaData annotatedMetaData = (Web25MetaData)unit.getAttachment(key, Web25MetaData.class);
        if (annotatedMetaData != null) {
            if (specMetaData != null) {
                Web25MetaData specMerged = new Web25MetaData();
                AnnotationMergedView.merge((WebMetaData)specMerged, (WebMetaData)specMetaData, (WebMetaData)annotatedMetaData);
                specMetaData = specMerged;
            } else {
                specMetaData = annotatedMetaData;
            }
        }
        JBossWebMetaData mergedMetaData = new JBossWebMetaData();
        mergedMetaData.merge(metaData, specMetaData);
        DeploymentUnit topUnit = unit.getTopLevel();
        if (topUnit != null && topUnit.getAttachment(JBossAppMetaData.class) != null) {
            SecurityRolesMetaData earSecurityRolesMetaData;
            JBossAppMetaData earMetaData = (JBossAppMetaData)topUnit.getAttachment(JBossAppMetaData.class);
            String securityDomain = earMetaData.getSecurityDomain();
            if (securityDomain != null && mergedMetaData.getSecurityDomain() == null) {
                mergedMetaData.setSecurityDomain(securityDomain);
            }
            if ((earSecurityRolesMetaData = earMetaData.getSecurityRoles()) != null) {
                SecurityRolesMetaData mergedSecurityRolesMetaData = mergedMetaData.getSecurityRoles();
                if (mergedSecurityRolesMetaData == null) {
                    mergedMetaData.setSecurityRoles(earSecurityRolesMetaData);
                }
                if (mergedSecurityRolesMetaData != null) {
                    mergedSecurityRolesMetaData.merge((IdMetaDataImpl)mergedSecurityRolesMetaData, (IdMetaDataImpl)earSecurityRolesMetaData);
                }
            }
        }
        unit.getTransientManagedObjects().addAttachment(JBossWebMetaData.class, (Object)mergedMetaData);
    }
}

