/*
 * Copyright 2013 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.workbench.common.widgets.client.callbacks;

import org.jboss.errai.bus.client.api.messaging.Message;
import org.kie.workbench.common.widgets.client.widget.HasBusyIndicator;
import org.uberfire.commons.validation.PortablePreconditions;

/**
 * Default Error handler for all views that support HasBusyIndicator
 */
public class HasBusyIndicatorDefaultErrorCallback extends DefaultErrorCallback {

    protected HasBusyIndicator view;

    public HasBusyIndicatorDefaultErrorCallback( final HasBusyIndicator view ) {
        this.view = PortablePreconditions.checkNotNull( "view",
                                                        view );
    }

    @Override
    public boolean error( final Message message,
                          final Throwable throwable ) {
        view.hideBusyIndicator();
        return super.error( message,
                            throwable );
    }

}
