package com.redhat.installer.postinstall;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

/**
 * ArgumentParser parses arguments of the following format:
 *      --key=value
 *
 * Anything else will be ignored
 */
public class ArgumentParser {
    private static final String ARGS_OPTION = "--";
    private static final String EQUAL_SIGN = "=";
    private static final int ARGS_OPTION_LENGTH = ARGS_OPTION.length();
    private Properties property;

    {
        property = new Properties();
    }
    public void parse(final String[] args) {
        try {
            for (String argument: args) {
                if (argument.startsWith(ARGS_OPTION) && argument.contains(EQUAL_SIGN)) {
                    // Escape the forward slash. Needed for load method to work properly
                    property.load(new StringReader(argument.substring(ARGS_OPTION_LENGTH).replaceAll("\\\\", "\\\\\\\\")));
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    public String getProperty(final String key) {
        return property.getProperty(key);
    }
    public String getProperty(final String key, final String defaultValue) {
        return property.getProperty(key, defaultValue);
    }
    public boolean hasProperty(final String key) {
        return property.containsKey(key);
    }

    public boolean propertyIsTrue(final String key) {
        return (hasProperty(key) && getProperty(key).equalsIgnoreCase("true"));
    }
}