package com.redhat.installer.postinstall;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.password.AddProperties;

/**
 * We use this process panel class to temporarily add an administrative account
 * user so we can modify install settings using the CLI during the post-install
 * portion of the installation.
 * 
 * We call the cleanUp method during installation shutdown in order to shut off
 * any running instances of the server, and then to remove the post-install user
 * from the server config files.
 * 
 * @author fcanas
 * 
 */
public class PostInstallUserHelper {
    public static final String USERNAME_VAR = "postinstall.username";
    public static final String PWD_VAR = "postinstall.password";
    public static final String REALM_VAR = "postinstall.realm";
    public static final String PATH_VAR = "postinstall.path";
    public static final String username = "POSTINSTALL.TEMPUSER";
    public static final String password = "POSTINSTALL.TEMPPASSWORD";

    private static AutomatedInstallData idata;
    private static final String ADD_USER = "add_user";
    private static final String REMOVE_USER = "remove_user";
    private static final String ADD_POSTUSER = "PostInstallUser.user.add";
    private static final String FAIL_POSTUSER = "PostInstallUser.user.fail";

    public static void run(AbstractUIProcessHandler handler, String[] args)
            throws Exception {
        idata = AutomatedInstallData.getInstance();

        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);

        String action = args[0];
        

        String realm = args[1];
        String path = args[2];

        if (action.contains(ADD_USER)) {
            String adminuser = idata.getVariable("adminUser");

            if ((adminuser != null) && adminuser.equals(username)) {
                username.concat("000");
            }

            addTemporaryUser(username, password, realm, path);
        } else if (action.contains(REMOVE_USER)) {
            removePostInstallUser();
        }

    }

    /**
     * Use this method to add a temporary admin account to the server for
     * manipulating properties with the CLI during installation.
     */
    private static void addTemporaryUser(String username, String password,
            String realm, String path) {
        idata = AutomatedInstallData.getInstance();

        // Check for the very unlikely case that the real admin name
        // is the same as the temporary user name:

        idata.setVariable(USERNAME_VAR, username);
        idata.setVariable(PWD_VAR, password);
        idata.setVariable(REALM_VAR, realm);
        idata.setVariable(PATH_VAR, path);

        try {
            AddProperties.addUser(username, password, realm, path, true);
        } catch (Exception e) {
            System.err.println(idata.langpack.getString(FAIL_POSTUSER));
        }
    }

    /**
     * Remove the temporary user used during post install to connect to the CLI.
     */
    public static void removePostInstallUser() {
        idata = AutomatedInstallData.getInstance();
        String username = idata.getVariable("postinstall.username");
        String path = idata.getVariable("postinstall.path");
        AddProperties.removeUser(username, path);
    }
}
