package com.redhat.installer.postinstall;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;

/**
 * Unfortunately, this wrapper is necessary in order to query the server for any values, because of the design of the CommandContext API,
 * which does not give back anything useful from the result of a command.
 *
 * @author thauser
 */

public class ServerVariableHelper {
	
	private static BufferedReader in;
	private static BufferedWriter out;
	private static AbstractUIProcessHandler mHandler;
    private static final String JBOSS_CLI = "jboss-cli";

	public static void run(AbstractUIProcessHandler handler, String [] args){
		AutomatedInstallData idata = AutomatedInstallData.getInstance();
		mHandler = handler;
		ArgumentParser parser = new ArgumentParser();
        parser.parse(args);

        String[] serverVars = new String[args.length-1];

        for (int i = 1; i < args.length; i++){
            serverVars[i-1] = args[i];
        }

		String workingDirectory = idata.getInstallPath()+File.separator+idata.getVariable("INSTALL_SUBPATH")+File.separator;

        for (final String var : serverVars){
            ProcessBuilder builder = new ProcessBuilder(workingDirectory+"bin"+File.separator+parser.getProperty(JBOSS_CLI),"-c","--command=/path="+var+":read-attribute(name=path)");

            builder.directory(new File(workingDirectory));
            ProcessPanelHelper.adjustJbossHome(builder);

            try {
                builder.redirectErrorStream(true);
                Process p = builder.start();
                in = new BufferedReader( new InputStreamReader(p.getInputStream()));
                out = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                out.newLine();
                out.flush();
                Thread eater = new Thread(new Runnable(){
                    public void run(){
                        try {
                            AutomatedInstallData idata = AutomatedInstallData.getInstance();
                            String line;
                            while ((line = in.readLine())!=null){
                                //ProcessPanelHelper.printToPanel(mHandler,line,false);
                                ProcessPanelHelper.printToPanel(mHandler,line,false);
                                if (line.contains("\"result\"")){
                                    // we found the variable we need!
                                    // the line will be formatted this way: "result" => "path/we/want"
                                    // split around goofy arrow
                                    String[] split = line.split("=>");
                                    // get the second element
                                    String result = split[1];
                                    // remove whitespace
                                    result = result.trim();
                                    // remove quotes
                                    result = result.substring(1, result.length()-1);
                                    // save value.
                                    idata.setVariable(var, result);
                                    ProcessPanelHelper.printToPanel(mHandler, var + " = " + result,false);
                                }
                            }
                        } catch (Exception e){
                            e.printStackTrace();
                        }
                    }
                });
                eater.start();
                int exit = p.waitFor();
                //System.out.println("ServerVariableHelper: " + exit);
            } catch (Exception e){
                e.printStackTrace();
            }

        }


			
			
	}
	
}
