package com.redhat.installer.postinstall;

import org.jboss.as.cli.CliInitializationException;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.util.ServerCommandsHelper;

import java.io.File;

/**
 * Class that is able to initialize the static Vault within the ServerCommands class. This allows for a vault to be used
 * even when the user has not chosen to install it. This functionality is necessary because of requirements to have no
 * plaintext passwords in any of the configuration files.
 *
 * @author thauser
 */
public class VaultInstaller {
	
	private static final String DOMAIN = "domain";
	private static final String KEYSTORE = "keystore";
	private static final String STORE_PASS = "storepass";
	private static final String ENCR_DIR = "encr-dir";
	private static final String SALT = "salt";
	private static final String ITERATIONS = "iterations";
	private static final String ALIAS = "alias";
		

	public static boolean run(AbstractUIProcessHandler handler, String[]args){
		AutomatedInstallData idata = AutomatedInstallData.getInstance();
		ArgumentParser parser = new ArgumentParser();
		parser.parse(args);
		
		String username = idata.getVariable("postinstall.username");
		char[] password = idata.getVariable("postinstall.password").toCharArray();
		ServerCommands sc = null;
		int port = ServerManager.getManagementPort();
		
		try {
			if (parser.hasProperty(DOMAIN)){
				sc = ServerCommands.createLocalDomainUsernameSession(username, password, port,  new String[]{"default","full","full-ha","ha"});
			} else {
				sc = ServerCommands.createLocalStandaloneUsernameSession(username, password,  port);
			}
		} catch (CliInitializationException clie){
			clie.printStackTrace();
		}
		
		try {
			String encrDir = parser.getProperty(ENCR_DIR);
			if (!encrDir.endsWith("/"))
				encrDir+="/";

			sc.createVaultSession(parser.getProperty(KEYSTORE), parser.getProperty(STORE_PASS), encrDir, parser.getProperty(SALT), Integer.parseInt(parser.getProperty(ITERATIONS)), parser.getProperty(ALIAS));
		} catch (NumberFormatException e) {
            // this will only happen if usage is wrong in the ProcessPanel.xml.Spec
			ProcessPanelHelper.printToPanel(handler, "NFE on iterations. Check ProcessPanelSpec.xml", true);
			e.printStackTrace();
		} catch (Throwable e) {
			//ProcessPanelHelper.printToPanel(handler, "Vault creation failed.", true)
            ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("VaultInstaller.session.failure"), true);
			e.printStackTrace();
            return false;
		}
		//ProcessPanelHelper.printToPanel(handler, "Vault creation successful. Vault session started.", false);
        ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("VaultInstaller.session.success"), false);
		
		try {
			ServerCommandsHelper.connectContext(handler, sc);
		} catch (InterruptedException e) {
			//e.printStackTrace();
		}		
		
		int result = sc.installVault("${jboss.server.config.dir}"+File.separator+"vault.keystore","${jboss.home.dir}"+File.separator+"vault");
		if (result == 0){
			//ProcessPanelHelper.printToPanel(handler, "Vault installation successful.", false);
			ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("VaultInstaller.install.success"), false);
			return true;
		} else {
			//ProcessPanelHelper.printToPanel(handler, "Vault installation failed.", true);
			ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("VaultInstaller.install.failure"), true);
			return false;
		}
	}
}
