package com.redhat.installer.validator;

import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.AutomatedInstallData;

import java.util.HashSet;
import java.util.Properties;
import java.util.ArrayList;

/**
 * A validator template to check for port collisions in a configuration
 * <p/>
 * This validator can be extended and used on any custom ports panel
 *
 * @author Jyoti Tripathi
 */
public abstract class PortCollisionValidator implements DataValidator
{
    public Status validateData (AutomatedInstallData idata) {
        Properties variables       = idata.getVariables();
        String[] varNames          = variables.stringPropertyNames().toArray(new String[0]);
        HashSet<Integer> ports         = new HashSet<Integer>();
        String configString = getConfig();
        ArrayList<String> exclusions = getExclusions();

        for (String variable : varNames) {
            if (variable.startsWith(configString+".") && !variable.startsWith(configString+".h.")
                    && !variable.startsWith(configString+".f.") && !variable.startsWith(configString+".fa.") 
                    && !variable.endsWith("-2") && !variable.endsWith(".orig")) {
                String value = variables.getProperty(variable);
                if ( value.startsWith("${") ) {
                    value = value.substring(value.indexOf(':')+1,value.indexOf('}'));
                }
                try {
                    if (!ports.add(Integer.parseInt(value))) {
                        if (exclusions == null || !exclusions.contains(variable) || Integer.parseInt(value) != 0) {
                            return Status.ERROR;
                        }
                    }
                } catch (Exception e){}
            }
        }
        return Status.OK;
    }

    public boolean getDefaultAnswer() {
        return true;
    }

    public String getWarningMessageId() {
        return null;
    }

    public String getErrorMessageId() {
        return AutomatedInstallData.getInstance().langpack.getString("port.collision.check.template");
    }

    protected abstract String getConfig();

    protected ArrayList<String> getExclusions() {
        return null;
    }
}
