package com.redhat.installer.tests.validator;

import com.redhat.installer.tests.DataValidatorTester;
import com.redhat.installer.tests.TestUtils;
import com.redhat.installer.validator.PreExistingVaultValidator;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import static junit.framework.TestCase.assertEquals;

/**
 * Created by thauser on 1/30/14.
 */
public class PreExistingVaultValidatorTest extends DataValidatorTester {
    @BeforeClass
    public static void specific() throws Exception{
        idata.langpack = TestUtils.createMockLangpack("ssl.password.incorrect");
    }

    @Before
    public void setUp() throws Exception {
        dv = new PreExistingVaultValidator();
    }

    @Test
    public void testWrongPassword() throws Exception {
        idata.setVariable("vault.keystoreloc", TestUtils.mockKeystorePath);
        idata.setVariable("vault.keystorepwd", "incorrectpassword"); // must be > 6 chars for mock keystore generation
        TestUtils.createMockKeystore("jks");
        assertWarning();
        assertLangpackError("ssl.password.incorrect");
    }

    // vault keystores are always of type jceks, so this test needs updating
    @Test
    public void testCorrectPassword() throws Exception {
        TestUtils.setCorrectVaultKeystoreVariables(idata);
        TestUtils.createMockKeystore("jks");
        assertOk();
        assertEquals("on", idata.getVariable("installVault"));
    }

    @Test
    public void testFileNotExist() throws Exception {
        TestUtils.setCorrectVaultKeystoreVariables(idata);
        assertWarning();
        assertLangpackError("ssl.password.incorrect");
    }

    @Test
    public void testNotJKSKeystore() throws Exception {
        TestUtils.setCorrectVaultKeystoreVariables(idata);
        TestUtils.createMockKeystore("jceks");
        assertOk();
    }
}
