package com.redhat.installer.tests.validator;

import com.redhat.installer.tests.DataValidatorTester;
import com.redhat.installer.tests.TestUtils;
import com.redhat.installer.validator.VaultValidator;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import static com.redhat.installer.tests.TestUtils.createNewEmptyFile;

/**
 * Created by thauser on 1/30/14.
 */
public class VaultValidatorTest extends DataValidatorTester {

    @BeforeClass
    public static void init() throws Exception{
        idata.langpack = TestUtils.createMockLangpack("vault.path.existing");
    }

    @Before
    public void setUp() throws Exception {
        dv = new VaultValidator();
    }

    @Test
    public void testExisting() throws Exception{
        createNewEmptyFile(TestUtils.mockKeystoreFilename);
        idata.setVariable("vault.keystoreloc", TestUtils.mockKeystorePath);
        assertError();
        assertLangpackError("vault.path.existing");
    }

    @Test
    public void testNonExisting() throws Exception{
        idata.setVariable("vault.keystoreloc", TestUtils.mockKeystorePath);
        assertOk();
    }

}
