#!/bin/sh

# computes MD5sums of all files. then checks them

# usage: MD5test.sh <dir1> <dir2>
# assumes that the given directories are direct children of the current dir

#TODO: make all of the grep -vE into a file or variable, so that it can be kept in one place. make sure to add 
#      more exemptions for things we know not to compare, because they will be different 100% surely

INSTALLDIR1=$1
INSTALLDIR2=$2

TIME=$(date '+%s')
pushd $INSTALLDIR1
find . -type f -print0 | xargs -0 md5sum > md5sums1-$TIME-temp.md5 # -print0 means terminate with null instead of newline, so xargs -0 lets us read all the files easy
cat md5sums1-$TIME-temp.md5 | grep -vE "md5sums1-$TIME-temp.md5" | grep -vE "uninstaller.jar" | grep -vE "InstallSummary.html" | grep -vE ".installationinformation" | grep -vE "auto.xml" > ../md5sums1-$TIME.md5
rm *.md5
popd

pushd $INSTALLDIR2
find . -type f -print0 | xargs -0 md5sum > md5sums2-$TIME-temp.md5
cat md5sums2-$TIME-temp.md5 | grep -vE "md5sums2-$TIME-temp.md5" | grep -vE "uninstaller.jar" | grep -vE "InstallSummary.html" | grep -vE ".installationinformation" | grep -vE "auto.xml" > ../md5sums2-$TIME.md5
rm *.md5
popd

RESULT=$(diff md5sums1-$TIME.md5 md5sums2-$TIME.md5)

#if the result isn't blank, there are diffs.
if [ "x" != "x$RESULT" ]
then
    echo The installations are not equal. There are MD5 differences.
    echo $RESULT
else
    echo There are no MD5 differences. The directories are identical.
fi
