#!/bin/bash
# Simple Script generator based on
# Danesh and Thomas work

EXPECTED_ARGS=1

if [ $# -ne $EXPECTED_ARGS ]
then
      echo "Usage: run.sh <profile>"
        exit 1
fi

echo "########################################"
echo "#                                      #"
echo "# Please don't click elsewhere on your #"
echo "#             screen!                  #"
echo "#                                      #"
echo "########################################"

# Create the final script
# and make it executable
FILE="testscript.sh"
> $FILE
chmod a+x $FILE

# Append the commands array to $FILE

cat $1 >> $FILE


# Get the final commands
cat final-commands >> $FILE


# Get
sleep 2
# Invoke the script
./$FILE


# If profile is custom port, run additional tests
if [ "$1" == "cli-custom-port" ]
then
    cd `cat INSTALL_PATH`

    X=`grep -c "<socket-binding name=" jboss-eap-6.0/standalone/configuration/standalone.xml`
    Y=`grep -c "ratm" jboss-eap-6.0/standalone/configuration/standalone.xml`

    if [ "$X" -eq "$Y" ]
    then
        echo ">>> It seems that all sockets have custom ports in standalone.xml<<<"
    else
        echo ">>> ERROR: Not all sockets have custom ports in standalone.xml <<<"
    fi

    Z=`grep -c "{standalone" jboss-eap-6.0/standalone/configuration/standalone.xml`

    if [ "$Z" -eq "0" ]
    then
        echo ">>> It seems that all variables have been parsed in standalone.xml <<<"
    else
        echo ">>> ERROR: Not all variables have been parsed in standalone.xml<<<"
    fi

    X=`grep -c "<socket-binding name=" jboss-eap-6.0/domain/configuration/domain.xml`
    Y=`grep -c "ratm" jboss-eap-6.0/domain/configuration/domain.xml`

    if [ "$X" -eq "$Y" ]
    then
        echo ">>> It seems that all sockets have custom ports in domain.xml <<<"
    else
        echo ">>> ERROR: Not all sockets have custom ports in domain.xml<<<"
    fi

    Z=`grep -c "{domain" jboss-eap-6.0/domain/configuration/domain.xml`

    if [ "$Z" -eq "0" ]
    then
        echo ">>> It seems that all variables have been parsed in domain.xml <<<"
    else
        echo ">>> ERROR: Not all variables have been parsed in domain.xml<<<"
    fi

fi
if [ "$1" == "cli-quickstarts-test" ]
then
    cd `cat INSTALL_PATH`
    ls | grep "quickstarts"
    if [ "$?" -eq "0" ]
    then
        echo ">>> Quickstarts installed successfully <<<"
    else
        echo "ERROR: Quickstarts not installed"
    fi
fi

if [ "$1" == "cli-treepacks-test" ]
then
    cd `cat INSTALL_PATH`
    cd jboss-eap-6.0

    # We have deselected welcome-content -- shouldn't be installed
    ls | grep "welcome-content"
    if [ "$?" -eq "0" ]
    then
        echo "ERROR: Treepacks installed deselected files"
    else
        echo ">>> Treepacks working <<<"
    fi
fi

if [ "$1" == "cli-treepacks-test" ]
then
    echo ">>> A web-browser should be open with the webpage of the server"
fi
