/* $Date: 2008-01-17 18:11:17 -0500 (Thu, 17 Jan 2008) $ $Id: www-mib-protocol.h 8676 2008-01-17 23:11:17Z ispringer $ harrie@covalent.net
 */
#ifndef	__WWW_MIB_PROTOCOL_H__
#define	__WWW_MIB_PROTOCOL_H__

/* enumerated wwwServiceOperStatus */
#define OPERSTATUS_DOWN		1
#define OPERSTATUS_RUNNING	2
#define OPERSTATUS_HALTED	3
#define OPERSTATUS_CONGESTED	4
#define OPERSTATUS_RESTARTING	5

/* columnar objects wwwSummaryEntry */
#define	WWWSUMMARYINREQUESTS	1
#define	WWWSUMMARYOUTREQUESTS	2
#define	WWWSUMMARYINRESPONSES	3
#define	WWWSUMMARYOUTRESPONSES	4
#define	WWWSUMMARYINBYTES	5
#define	WWWSUMMARYINLOWBYTES	6
#define	WWWSUMMARYOUTBYTES	7
#define	WWWSUMMARYOUTLOWBYTES	8

/* columnar objects of the wwwRequestInEntry */
#define	WWWREQUESTINREQUESTS	2
#define	WWWREQUESTINBYTES	3
#define	WWWREQUESTINLASTIME	4

/* columnar objects of the wwwRequestOutEntry */
#define	WWWREQUESTOUTREQUESTS	2
#define	WWWREQUESTOUTBYTES	3
#define	WWWREQUESTOUTLASTTIME	4

/* columnar objects of the wwwResponseInEntry */
#define	WWWRESPONSEINRESPONSES	2
#define	WWWRESPONSEINBYTES	3
#define	WWWRESPONSEINLASTTIME	4

/* columnar objects of the wwwResponseOutEntry, 2 */
#define	WWWRESPONSEOUTRESPONSES	2
#define	WWWRESPONSEOUTBYTES	3
#define	WWWRESPONSEOUTLASTTIME	4

/* Specific type definitions for the HTTP protocol specific tables. */
/* Request In and Out have each there own type.                     */
/* Maybe in the future we want to extend either one.                */
typedef struct {
    unsigned long requests;
    unsigned long bytes;
    apr_time_t lastTime;
} wwwRequestIn_t;

typedef struct {
    unsigned long requests;
    unsigned long bytes; 
    apr_time_t lastTime;
} wwwRequestOut_t;

/* Response In and Out have each there own type.                    */
/* Maybe in the future we want to extend either one.                */
typedef struct {
    unsigned long responses;
    unsigned long bytes; 
    apr_time_t lastTime;
} wwwResponseIn_t;

typedef struct {
    unsigned long responses;
    unsigned long bytes; 
    apr_time_t lastTime;
} wwwResponseOut_t;

typedef struct {
    /* This is the protocol definition for the statistics. */
    www_protocol_t *protocol;
    /* The information of the summary table. */
    unsigned long wwwSummaryInRequests;
    unsigned long wwwSummaryOutRequests;
    unsigned long wwwSummaryInResponses;
    unsigned long wwwSummaryOutResponses;
    unsigned long wwwSummaryInLowBytes;
    unsigned long wwwSummaryOutLowBytes;
#ifndef NO_WWW_REQUEST_IN_GROUP
    /* The www request in specific statistics. */
    wwwRequestIn_t *wwwRequestIn;
#endif
#ifndef NO_WWW_REQUEST_OUT_GROUP
    /* The www request out specific statistics. */
    wwwRequestOut_t *wwwRequestOut;
#endif
#ifndef NO_WWW_RESPONSE_IN_GROUP
    /* The www response in specific statistics. */
    wwwResponseIn_t *wwwResponseIn;
#endif
#ifndef NO_WWW_RESPONSE_OUT_GROUP
    /* The www response out specific statistics. */
    wwwResponseOut_t *wwwResponseOut;
#endif
} wwwProtocolStatistics_t;

void init_www_mib_protocol(apr_pool_t *p);
const char *update_www_mib_protocol_statistics(unsigned int wwwServiceIndex,
                                   unsigned int wwwProtocol,
                                   apr_time_t wwwRequestTime,
                                   unsigned long wwwRequestInType,
                                   unsigned long wwwBytesIn,
                                   unsigned long wwwResponseOutType,
                                   unsigned long wwwBytesOut,
                                   char *wwwDocName,
                                   char *wwwStatusMsg);
#endif /* __WWW_MIB_PROTOCOL_H__ */
