package jbosson.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProductServlet extends HttpServlet {
	private int counter;
	@Override
	protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
		try {
			counter++;
			Context c = new InitialContext();
			ProductService ps = (ProductService)c.lookup("jbosson-simple/ProductServiceBean/local");
			
			
			String cmd = arg0.getParameter("cmd");
			String url = "/index.jsp";
			if (cmd!=null) {
				if (cmd.equals("create")) {
					Product p = new Product();
					p.name = arg0.getParameter("name");
					p.price = 0;
					try{
						p.price = Double.parseDouble(arg0.getParameter("price"));
					} catch (Exception e) {
						log.info(e.getMessage());
					}
					ProductService ps2 = (ProductService)c.lookup("jbosson-simple/ProductServiceBean/local");
					ps2.createProduct(p);
				} else if (cmd.equals("underperforming")) {
					url = "/underperforming.jsp";
				}
			}
			List<Product> products = null;
			try {
				products = ps.getProducts();
			} catch (Exception e) {
				products = new ArrayList<Product>();
			}
			arg0.setAttribute("products",products);
			arg0.setAttribute("counter",counter);
			RequestDispatcher rd = arg0.getRequestDispatcher(url);
			rd.forward(arg0, arg1);
		} catch (Exception e) {
			throw new ServletException(e);
		}
	}
		
	private static Logger log = Logger.getLogger(ProductServlet.class.getName());
	
}
