/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.util.Collection;
import java.util.HashSet;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.metadata.ContentSourcePluginMetadataManager;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.content.ContentPluginDescriptorType;

public class ContentServerPluginManager
extends ServerPluginManager {
    private ContentSourcePluginMetadataManager metadataManager;

    public ContentServerPluginManager(ContentServerPluginContainer pc) {
        super(pc);
    }

    public void initialize() throws Exception {
        super.initialize();
        this.metadataManager = new ContentSourcePluginMetadataManager();
    }

    public void shutdown() {
        super.shutdown();
        this.metadataManager = null;
    }

    public ServerPluginEnvironment getPluginEnvironment(ContentSourceType type) {
        String pluginName = this.metadataManager.getPluginNameFromContentSourceType(type);
        return this.getPluginEnvironment(pluginName);
    }

    public ContentSourcePluginMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        super.loadPlugin(env, enabled);
        if (enabled) {
            Collection<ContentSourceType> newTypes = this.metadataManager.loadPlugin((ContentPluginDescriptorType)env.getPluginDescriptor());
            HashSet<ContentSourceType> newTypesCopy = new HashSet<ContentSourceType>(newTypes);
            for (ContentSourceType newType : newTypesCopy) {
                try {
                    String className = newType.getContentSourceApiClass();
                    Class<?> apiClass = Class.forName(className, false, env.getPluginClassLoader());
                    if (ContentProvider.class.isAssignableFrom(apiClass)) continue;
                    throw new Exception("The API class [" + className + "] should implement [" + ContentProvider.class.getName() + "] but does not");
                }
                catch (Exception e) {
                    try {
                        this.unloadPlugin(env.getPluginKey().getPluginName());
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
            }
        }
    }

    public void unloadPlugin(String pluginName) throws Exception {
        this.metadataManager.unloadPlugin(pluginName);
        super.unloadPlugin(pluginName);
    }
}

