/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtendedAccessLogValve
extends AccessLogValve
implements Lifecycle {
    private static Log log = LogFactory.getLog(ExtendedAccessLogValve.class);
    protected static final String extendedAccessLogInfo = "org.apache.catalina.valves.ExtendedAccessLogValve/1.0";

    public String getInfo() {
        return extendedAccessLogInfo;
    }

    private String wrap(Object value) {
        String svalue;
        if (value == null || "-".equals(value)) {
            return "-";
        }
        try {
            svalue = value.toString();
            if ("".equals(svalue)) {
                return "-";
            }
        }
        catch (Throwable e) {
            return "-";
        }
        StringBuffer buffer = new StringBuffer(svalue.length() + 2);
        buffer.append('\'');
        int i = 0;
        while (i < svalue.length()) {
            int j = svalue.indexOf(39, i);
            if (j == -1) {
                buffer.append(svalue.substring(i));
                i = svalue.length();
                continue;
            }
            buffer.append(svalue.substring(i, j + 1));
            buffer.append('\"');
            i = j + 2;
        }
        buffer.append('\'');
        return buffer.toString();
    }

    protected synchronized void open() {
        super.open();
        if (this.currentLogFile.length() == 0L) {
            this.writer.println("#Fields: " + this.pattern);
            this.writer.println("#Version: 1.0");
            this.writer.println("#Software: " + ServerInfo.getServerInfo());
        }
    }

    protected AccessLogValve.AccessLogElement[] createLogElements() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("decodePattern, pattern =" + this.pattern));
        }
        ArrayList<AccessLogValve.AccessLogElement> list = new ArrayList<AccessLogValve.AccessLogElement>();
        PatternTokenizer tokenizer = new PatternTokenizer(this.pattern);
        try {
            tokenizer.getWhiteSpaces();
            if (tokenizer.isEnded()) {
                log.info((Object)"pattern was just empty or whitespace");
                return null;
            }
            String token = tokenizer.getToken();
            while (token != null) {
                AccessLogValve.AccessLogElement element;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("token = " + token));
                }
                if ((element = this.getLogElement(token, tokenizer)) == null) break;
                list.add(element);
                String whiteSpaces = tokenizer.getWhiteSpaces();
                if (whiteSpaces.length() > 0) {
                    list.add(new AccessLogValve.StringElement(whiteSpaces));
                }
                if (tokenizer.isEnded()) break;
                token = tokenizer.getToken();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("finished decoding with element size of: " + list.size()));
            }
            return list.toArray(new AccessLogValve.AccessLogElement[0]);
        }
        catch (IOException e) {
            log.error((Object)"parse error", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccessLogValve.AccessLogElement getLogElement(String token, PatternTokenizer tokenizer) throws IOException {
        if ("date".equals(token)) {
            return new DateElement();
        }
        if ("time".equals(token)) {
            if (!tokenizer.hasSubToken()) return new TimeElement();
            String nextToken = tokenizer.getToken();
            if ("taken".equals(nextToken)) {
                return new AccessLogValve.ElapsedTimeElement(false);
            }
        } else {
            if ("bytes".equals(token)) {
                return new AccessLogValve.ByteSentElement(true);
            }
            if ("cached".equals(token)) {
                return new AccessLogValve.StringElement("-");
            }
            if ("c".equals(token)) {
                String nextToken = tokenizer.getToken();
                if ("ip".equals(nextToken)) {
                    return new AccessLogValve.RemoteAddrElement();
                }
                if ("dns".equals(nextToken)) {
                    return new AccessLogValve.HostElement();
                }
            } else if ("s".equals(token)) {
                String nextToken = tokenizer.getToken();
                if ("ip".equals(nextToken)) {
                    return new AccessLogValve.LocalAddrElement();
                }
                if ("dns".equals(nextToken)) {
                    return new AccessLogValve.AccessLogElement(){

                        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                            String value;
                            try {
                                value = InetAddress.getLocalHost().getHostName();
                            }
                            catch (Throwable e) {
                                value = "localhost";
                            }
                            buf.append(value);
                        }
                    };
                }
            } else {
                if ("cs".equals(token)) {
                    return this.getClientToServerElement(tokenizer);
                }
                if ("sc".equals(token)) {
                    return this.getServerToClientElement(tokenizer);
                }
                if ("sr".equals(token) || "rs".equals(token)) {
                    return this.getProxyElement(tokenizer);
                }
                if ("x".equals(token)) {
                    return this.getXParameterElement(tokenizer);
                }
            }
        }
        log.error((Object)("unable to decode with rest of chars starting: " + token));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccessLogValve.AccessLogElement getClientToServerElement(PatternTokenizer tokenizer) throws IOException {
        if (tokenizer.hasSubToken()) {
            String token = tokenizer.getToken();
            if ("method".equals(token)) {
                return new AccessLogValve.MethodElement();
            }
            if ("uri".equals(token)) {
                if (!tokenizer.hasSubToken()) return new AccessLogValve.AccessLogElement(){

                    public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                        String query = request.getQueryString();
                        if (query != null) {
                            buf.append(request.getRequestURI());
                        } else {
                            buf.append(request.getRequestURI());
                            buf.append('?');
                            buf.append(request.getQueryString());
                        }
                    }
                };
                token = tokenizer.getToken();
                if ("stem".equals(token)) {
                    return new AccessLogValve.RequestURIElement();
                }
                if ("query".equals(token)) {
                    return new AccessLogValve.AccessLogElement(){

                        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                            String query = request.getQueryString();
                            if (query != null) {
                                buf.append(query);
                            } else {
                                buf.append('-');
                            }
                        }
                    };
                }
            }
        } else if (tokenizer.hasParameter()) {
            String parameter = tokenizer.getParameter();
            if (parameter != null) return new RequestHeaderElement(parameter);
            log.error((Object)"No closing ) found for in decode");
            return null;
        }
        log.error((Object)("The next characters couldn't be decoded: " + tokenizer.getRemains()));
        return null;
    }

    protected AccessLogValve.AccessLogElement getServerToClientElement(PatternTokenizer tokenizer) throws IOException {
        if (tokenizer.hasSubToken()) {
            String token = tokenizer.getToken();
            if ("status".equals(token)) {
                return new AccessLogValve.HttpStatusCodeElement();
            }
            if ("comment".equals(token)) {
                return new AccessLogValve.StringElement("?");
            }
        } else if (tokenizer.hasParameter()) {
            String parameter = tokenizer.getParameter();
            if (parameter == null) {
                log.error((Object)"No closing ) found for in decode");
                return null;
            }
            return new ResponseHeaderElement(parameter);
        }
        log.error((Object)("The next characters couldn't be decoded: " + tokenizer.getRemains()));
        return null;
    }

    protected AccessLogValve.AccessLogElement getProxyElement(PatternTokenizer tokenizer) throws IOException {
        String token = null;
        if (tokenizer.hasSubToken()) {
            token = tokenizer.getToken();
            return new AccessLogValve.StringElement("-");
        }
        if (tokenizer.hasParameter()) {
            tokenizer.getParameter();
            return new AccessLogValve.StringElement("-");
        }
        log.error((Object)("The next characters couldn't be decoded: " + token));
        return null;
    }

    protected AccessLogValve.AccessLogElement getXParameterElement(PatternTokenizer tokenizer) throws IOException {
        if (!tokenizer.hasSubToken()) {
            log.error((Object)"x param in wrong format. Needs to be 'x-#(...)' read the docs!");
            return null;
        }
        String token = tokenizer.getToken();
        if (!tokenizer.hasParameter()) {
            log.error((Object)"x param in wrong format. Needs to be 'x-#(...)' read the docs!");
            return null;
        }
        String parameter = tokenizer.getParameter();
        if (parameter == null) {
            log.error((Object)"No closing ) found for in decode");
            return null;
        }
        if ("A".equals(token)) {
            return new ServletContextElement(parameter);
        }
        if ("C".equals(token)) {
            return new CookieElement(parameter);
        }
        if ("R".equals(token)) {
            return new RequestAttributeElement(parameter);
        }
        if ("S".equals(token)) {
            return new SessionAttributeElement(parameter);
        }
        if ("H".equals(token)) {
            return this.getServletRequestElement(parameter);
        }
        if ("P".equals(token)) {
            return new RequestParameterElement(parameter);
        }
        log.error((Object)("x param for servlet request, couldn't decode value: " + token));
        return null;
    }

    protected AccessLogValve.AccessLogElement getServletRequestElement(String parameter) {
        if ("authType".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getAuthType()));
                }
            };
        }
        if ("remoteUser".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getRemoteUser()));
                }
            };
        }
        if ("requestedSessionId".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getRequestedSessionId()));
                }
            };
        }
        if ("requestedSessionIdFromCookie".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap("" + request.isRequestedSessionIdFromCookie()));
                }
            };
        }
        if ("requestedSessionIdValid".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap("" + request.isRequestedSessionIdValid()));
                }
            };
        }
        if ("contentLength".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap("" + request.getContentLength()));
                }
            };
        }
        if ("characterEncoding".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getCharacterEncoding()));
                }
            };
        }
        if ("locale".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getLocale()));
                }
            };
        }
        if ("protocol".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getProtocol()));
                }
            };
        }
        if ("scheme".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(request.getScheme());
                }
            };
        }
        if ("secure".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap("" + request.isSecure()));
                }
            };
        }
        log.error((Object)("x param for servlet request, couldn't decode value: " + parameter));
        return null;
    }

    protected class PatternTokenizer {
        private StringReader sr = null;
        private StringBuffer buf = new StringBuffer();
        private boolean ended = false;
        private boolean subToken;
        private boolean parameter;

        public PatternTokenizer(String str) {
            this.sr = new StringReader(str);
        }

        public boolean hasSubToken() {
            return this.subToken;
        }

        public boolean hasParameter() {
            return this.parameter;
        }

        public String getToken() throws IOException {
            if (this.ended) {
                return null;
            }
            String result = null;
            this.subToken = false;
            this.parameter = false;
            int c = this.sr.read();
            while (c != -1) {
                switch (c) {
                    case 32: {
                        result = this.buf.toString();
                        this.buf = new StringBuffer();
                        this.buf.append((char)c);
                        return result;
                    }
                    case 45: {
                        result = this.buf.toString();
                        this.buf = new StringBuffer();
                        this.subToken = true;
                        return result;
                    }
                    case 40: {
                        result = this.buf.toString();
                        this.buf = new StringBuffer();
                        this.parameter = true;
                        return result;
                    }
                    case 41: {
                        result = this.buf.toString();
                        this.buf = new StringBuffer();
                        break;
                    }
                    default: {
                        this.buf.append((char)c);
                    }
                }
                c = this.sr.read();
            }
            this.ended = true;
            if (this.buf.length() != 0) {
                return this.buf.toString();
            }
            return null;
        }

        public String getParameter() throws IOException {
            if (!this.parameter) {
                return null;
            }
            this.parameter = false;
            int c = this.sr.read();
            while (c != -1) {
                if (c == 41) {
                    String result = this.buf.toString();
                    this.buf = new StringBuffer();
                    return result;
                }
                this.buf.append((char)c);
                c = this.sr.read();
            }
            return null;
        }

        public String getWhiteSpaces() throws IOException {
            if (this.isEnded()) {
                return "";
            }
            StringBuffer whiteSpaces = new StringBuffer();
            if (this.buf.length() > 0) {
                whiteSpaces.append(this.buf);
                this.buf = new StringBuffer();
            }
            int c = this.sr.read();
            while (Character.isWhitespace((char)c)) {
                whiteSpaces.append((char)c);
                c = this.sr.read();
            }
            if (c == -1) {
                this.ended = true;
            } else {
                this.buf.append((char)c);
            }
            return whiteSpaces.toString();
        }

        public boolean isEnded() {
            return this.ended;
        }

        public String getRemains() throws IOException {
            StringBuffer remains = new StringBuffer();
            int c = this.sr.read();
            while (c != -1) {
                remains.append((char)c);
                c = this.sr.read();
            }
            return remains.toString();
        }
    }

    protected class RequestParameterElement
    implements AccessLogValve.AccessLogElement {
        private String parameter;

        public RequestParameterElement(String parameter) {
            this.parameter = parameter;
        }

        private String urlEncode(String value) {
            if (null == value || value.length() == 0) {
                return null;
            }
            return URLEncoder.encode(value);
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(this.urlEncode(request.getParameter(this.parameter))));
        }
    }

    protected class SessionAttributeElement
    implements AccessLogValve.AccessLogElement {
        private String attribute;

        public SessionAttributeElement(String attribute) {
            this.attribute = attribute;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            HttpSession session = null;
            if (request != null && (session = request.getSession(false)) != null) {
                buf.append(ExtendedAccessLogValve.this.wrap(session.getAttribute(this.attribute)));
            }
        }
    }

    protected class RequestAttributeElement
    implements AccessLogValve.AccessLogElement {
        private String attribute;

        public RequestAttributeElement(String attribute) {
            this.attribute = attribute;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(request.getAttribute(this.attribute)));
        }
    }

    protected class CookieElement
    implements AccessLogValve.AccessLogElement {
        private String name;

        public CookieElement(String name) {
            this.name = name;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            Cookie[] c = request.getCookies();
            for (int i = 0; c != null && i < c.length; ++i) {
                if (!this.name.equals(c[i].getName())) continue;
                buf.append(ExtendedAccessLogValve.this.wrap(c[i].getValue()));
            }
        }
    }

    protected class ServletContextElement
    implements AccessLogValve.AccessLogElement {
        private String attribute;

        public ServletContextElement(String attribute) {
            this.attribute = attribute;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(request.getContext().getServletContext().getAttribute(this.attribute)));
        }
    }

    protected class ResponseHeaderElement
    implements AccessLogValve.AccessLogElement {
        private String header;

        public ResponseHeaderElement(String header) {
            this.header = header;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(response.getHeader(this.header)));
        }
    }

    protected class RequestHeaderElement
    implements AccessLogValve.AccessLogElement {
        private String header;

        public RequestHeaderElement(String header) {
            this.header = header;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(request.getHeader(this.header)));
        }
    }

    protected class TimeElement
    implements AccessLogValve.AccessLogElement {
        private Date currentDate = new Date(0L);
        private String currentTimeString = null;
        private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");

        public TimeElement() {
            this.timeFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (this.currentDate != date) {
                TimeElement timeElement = this;
                synchronized (timeElement) {
                    if (this.currentDate != date) {
                        this.currentTimeString = this.timeFormatter.format(date);
                        this.currentDate = date;
                    }
                }
            }
            buf.append(this.currentTimeString);
        }
    }

    protected class DateElement
    implements AccessLogValve.AccessLogElement {
        private Date currentDate = new Date(0L);
        private String currentDateString = null;
        private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");

        public DateElement() {
            this.dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (this.currentDate != date) {
                DateElement dateElement = this;
                synchronized (dateElement) {
                    if (this.currentDate != date) {
                        this.currentDateString = this.dateFormatter.format(date);
                        this.currentDate = date;
                    }
                }
            }
            buf.append(this.currentDateString);
        }
    }
}

