/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryRunner<T> {
    private Criteria criteria;
    private CriteriaQueryGenerator queryGenerator;
    private EntityManager entityManager;
    private boolean autoInitializeBags;

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager) {
        this(criteria, queryGenerator, entityManager, true);
    }

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager, boolean autoInitializeBags) {
        this.criteria = criteria;
        this.queryGenerator = queryGenerator;
        this.entityManager = entityManager;
        this.autoInitializeBags = autoInitializeBags;
    }

    public PageList<T> execute() {
        Query query = this.queryGenerator.getQuery(this.entityManager);
        Query countQuery = this.queryGenerator.getCountQuery(this.entityManager);
        long count = (Long)countQuery.getSingleResult();
        List results = query.getResultList();
        if (this.autoInitializeBags && !this.queryGenerator.getPersistentBagFields().isEmpty()) {
            for (Object entity : results) {
                this.initPersistentBags(entity);
            }
        }
        return new PageList((Collection)results, (int)count, CriteriaQueryGenerator.getPageControl(this.criteria));
    }

    public void initPersistentBags(Object entity) {
        for (Field persistentBagField : this.queryGenerator.getPersistentBagFields()) {
            List<?> persistentBag = this.getList(entity, persistentBagField);
            persistentBag.size();
        }
    }

    private List<?> getList(Object entity, Field field) {
        try {
            field.setAccessible(true);
            return (List)field.get(entity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

