/**
 * Copyright 2018 The original authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.dekorate.testing.kubernetes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

import io.dekorate.DekorateException;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.project.FileProjectFactory;
import io.dekorate.project.Project;
import io.dekorate.utils.Serialization;

public interface WithKubernetesConfig {

  String CONFIG_DIR = "config";
  String KUBERNETES_YML = "kubernetes.yml";

  default boolean hasKubernetesConfig()  {
    return getKubernetesConfigPath().toFile().exists();
  }

  default KubernetesConfig getKubernetesConfig() {
    return getKubernetesConfig(getKubernetesConfigPath());
  }

  default Path getKubernetesConfigPath() {
    Project p =  new FileProjectFactory().create(new File("."));
    return p.getBuildInfo().getClassOutputDir().resolve(p.getDekorateMetaDir()).resolve(CONFIG_DIR).resolve(KUBERNETES_YML);
  }

  default KubernetesConfig getKubernetesConfig(Path path) {
    File f = path.toFile();
    if (f.exists()) {
      try (InputStream is = new FileInputStream(f))  {
        return Serialization.unmarshal(is, KubernetesConfig.class);
      } catch (IOException e) {
        throw DekorateException.launderThrowable(e);
      }
    }

    throw new IllegalStateException("Expected to find kubernetes config at: " + path + "!");
  }
}
