/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.io;

import com.mchange.v2.io.DirectoryDescentUtils;
import com.mchange.v2.io.FileIterator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileUtils {
    public static File findRelativeToParent(File parentDir, File file) throws IOException {
        String parentPath = parentDir.getPath();
        String filePath = file.getPath();
        if (!filePath.startsWith(parentPath)) {
            throw new IllegalArgumentException(filePath + " is not a child of " + parentPath + " [no transformations or canonicalizations tried]");
        }
        String maybeRelative = filePath.substring(parentPath.length());
        File out = new File(maybeRelative);
        if (out.isAbsolute()) {
            out = new File(out.getPath().substring(1));
        }
        return out;
    }

    public static long diskSpaceUsed(File maybeDir) throws IOException {
        long sum = 0L;
        FileIterator ff = DirectoryDescentUtils.depthFirstEagerDescent(maybeDir);
        while (ff.hasNext()) {
            File addMe = ff.nextFile();
            if (!addMe.isFile()) continue;
            sum += addMe.length();
        }
        return sum;
    }

    public static void touchExisting(File file) throws IOException {
        if (file.exists()) {
            FileUtils.unguardedTouch(file);
        }
    }

    public static void touch(File file) throws IOException {
        if (!file.exists()) {
            FileUtils.createEmpty(file);
        }
        FileUtils.unguardedTouch(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createEmpty(File file) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rws");
            raf.setLength(0L);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void unguardedTouch(File file) throws IOException {
        file.setLastModified(System.currentTimeMillis());
    }

    private FileUtils() {
    }
}

