/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.TreeSet;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugAccumulator {
    private BugReporter reporter;
    private final boolean performAccumulation;
    private MultiMap<BugInstance, SourceLineAnnotation> map;

    public BugAccumulator(BugReporter reporter) {
        this.reporter = reporter;
        this.performAccumulation = AnalysisContext.currentAnalysisContext().getBoolProperty(7);
        this.map = new MultiMap(TreeSet.class);
    }

    public void accumulateBug(BugInstance bug, SourceLineAnnotation sourceLine) {
        if (this.performAccumulation) {
            this.map.add(bug, sourceLine);
        } else {
            this.reporter.reportBug(bug.addSourceLine(sourceLine));
        }
    }

    public void accumulateBug(BugInstance bug, BytecodeScanningDetector visitor) {
        SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction(visitor);
        this.accumulateBug(bug, source);
    }

    public Iterable<? extends BugInstance> uniqueBugs() {
        return this.map.keySet();
    }

    public Iterable<? extends SourceLineAnnotation> locations(BugInstance bug) {
        return this.map.get(bug);
    }

    public void reportAccumulatedBugs() {
        for (BugInstance bug : this.map.keySet()) {
            boolean first = true;
            for (SourceLineAnnotation source : this.map.get(bug)) {
                if (source == null) continue;
                bug.addSourceLine(source);
                if (first) {
                    first = false;
                    continue;
                }
                bug.describe("SOURCE_LINE_ANOTHER_INSTANCE");
            }
            this.reporter.reportBug(bug);
        }
        this.clearBugs();
    }

    public void clearBugs() {
        this.map.clear();
    }

    public void accumulateBug(BugInstance bug, ClassContext classContext, Method method, Location location) {
        this.accumulateBug(bug, SourceLineAnnotation.fromVisitedInstruction(classContext, method, location));
    }

    public void accumulateBug(BugInstance bug, ClassContext classContext, MethodGen methodGen, String sourceFile, Location location) {
        this.accumulateBug(bug, SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, location.getHandle()));
    }
}

