/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ch;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.ch.ClassVertex;
import edu.umd.cs.findbugs.ba.ch.InheritanceEdge;
import edu.umd.cs.findbugs.ba.ch.InheritanceGraph;
import edu.umd.cs.findbugs.ba.ch.InheritanceGraphVisitor;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.graph.GraphVertex;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import edu.umd.cs.findbugs.util.MapCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParametersAreNonnullByDefault
public class Subtypes2 {
    public static final boolean ENABLE_SUBTYPES2 = true;
    public static final boolean ENABLE_SUBTYPES2_FOR_COMMON_SUPERCLASS_QUERIES = true;
    public static final boolean DEBUG = SystemProperties.getBoolean("findbugs.subtypes2.debug");
    public static final boolean DEBUG_QUERIES = SystemProperties.getBoolean("findbugs.subtypes2.debugqueries");
    private final InheritanceGraph graph = new InheritanceGraph();
    private final Map<ClassDescriptor, ClassVertex> classDescriptorToVertexMap = new HashMap<ClassDescriptor, ClassVertex>();
    private final Map<ClassDescriptor, SupertypeQueryResults> supertypeSetMap = new MapCache<ClassDescriptor, SupertypeQueryResults>(500);
    private final Map<ClassDescriptor, Set<ClassDescriptor>> subtypeSetMap = new MapCache<ClassDescriptor, Set<ClassDescriptor>>(500);
    private final Set<XClass> xclassSet = new HashSet<XClass>();
    private final DualKeyHashMap<ReferenceType, ReferenceType, ReferenceType> firstCommonSuperclassQueryCache;
    private final ObjectType SERIALIZABLE = ObjectTypeFactory.getInstance("java.io.Serializable");
    private final ObjectType CLONEABLE = ObjectTypeFactory.getInstance("java.lang.Cloneable");

    public Subtypes2() {
        this.firstCommonSuperclassQueryCache = new DualKeyHashMap();
    }

    public InheritanceGraph getGraph() {
        return this.graph;
    }

    public static boolean instanceOf(@DottedClassName String dottedSubtype, @DottedClassName String dottedSupertype) {
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        ClassDescriptor subDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(dottedSubtype);
        ClassDescriptor superDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(dottedSupertype);
        try {
            return subtypes2.isSubtype(subDescriptor, superDescriptor);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    public static boolean instanceOf(ClassDescriptor subDescriptor, @DottedClassName String dottedSupertype) {
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        ClassDescriptor superDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(dottedSupertype);
        try {
            return subtypes2.isSubtype(subDescriptor, superDescriptor);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    public static boolean instanceOf(JavaClass subtype, @DottedClassName String dottedSupertype) {
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        ClassDescriptor subDescriptor = DescriptorFactory.createClassDescriptor(subtype);
        ClassDescriptor superDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(dottedSupertype);
        try {
            return subtypes2.isSubtype(subDescriptor, superDescriptor);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    public void addApplicationClass(XClass appXClass) {
        ClassVertex vertex = this.addClassAndGetClassVertex(appXClass);
        vertex.markAsApplicationClass();
    }

    public boolean isApplicationClass(ClassDescriptor descriptor) {
        assert (descriptor != null);
        try {
            return this.resolveClassVertex(descriptor).isApplicationClass();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return true;
        }
    }

    public void addClass(XClass xclass) {
        this.addClassAndGetClassVertex(xclass);
    }

    private ClassVertex addClassAndGetClassVertex(XClass xclass) {
        if (xclass == null) {
            throw new IllegalStateException();
        }
        LinkedList<XClass> workList = new LinkedList<XClass>();
        workList.add(xclass);
        while (!workList.isEmpty()) {
            XClass work = (XClass)workList.removeFirst();
            ClassVertex vertex = this.classDescriptorToVertexMap.get(work.getClassDescriptor());
            if (vertex != null && vertex.isFinished()) continue;
            if (vertex == null) {
                vertex = ClassVertex.createResolvedClassVertex(work.getClassDescriptor(), work);
                this.addVertexToGraph(work.getClassDescriptor(), vertex);
            }
            this.addSupertypeEdges(vertex, workList);
            vertex.setFinished(true);
        }
        return this.classDescriptorToVertexMap.get(xclass.getClassDescriptor());
    }

    private void addVertexToGraph(ClassDescriptor classDescriptor, ClassVertex vertex) {
        assert (this.classDescriptorToVertexMap.get(classDescriptor) == null);
        if (DEBUG) {
            System.out.println("Adding " + classDescriptor.toDottedClassName() + " to inheritance graph");
        }
        this.graph.addVertex(vertex);
        this.classDescriptorToVertexMap.put(classDescriptor, vertex);
        if (vertex.isResolved()) {
            this.xclassSet.add(vertex.getXClass());
        }
        if (vertex.isInterface()) {
            this.addInheritanceEdge(vertex, DescriptorFactory.instance().getClassDescriptor("java/lang/Object"), false, null);
        }
    }

    public boolean isSubtype(ReferenceType type, ReferenceType possibleSupertype) throws ClassNotFoundException {
        if (type.equals(possibleSupertype)) {
            return true;
        }
        if (possibleSupertype.equals(ObjectType.OBJECT)) {
            return true;
        }
        if (type.equals(ObjectType.OBJECT)) {
            return false;
        }
        boolean typeIsObjectType = type instanceof ObjectType;
        boolean possibleSupertypeIsObjectType = possibleSupertype instanceof ObjectType;
        if (typeIsObjectType && possibleSupertypeIsObjectType) {
            return this.isSubtype((ObjectType)type, (ObjectType)possibleSupertype);
        }
        boolean typeIsArrayType = type instanceof ArrayType;
        boolean possibleSupertypeIsArrayType = possibleSupertype instanceof ArrayType;
        if (typeIsArrayType) {
            if (possibleSupertype.equals(this.SERIALIZABLE) || possibleSupertype.equals(this.CLONEABLE)) {
                return true;
            }
            if (!possibleSupertypeIsArrayType) {
                return false;
            }
            ArrayType typeAsArrayType = (ArrayType)type;
            ArrayType possibleSupertypeAsArrayType = (ArrayType)possibleSupertype;
            if (typeAsArrayType.getDimensions() < possibleSupertypeAsArrayType.getDimensions()) {
                return false;
            }
            Type possibleSupertypeBasicType = possibleSupertypeAsArrayType.getBasicType();
            if (!(possibleSupertypeBasicType instanceof ObjectType)) {
                return false;
            }
            Type typeBasicType = typeAsArrayType.getBasicType();
            if (typeAsArrayType.getDimensions() > possibleSupertypeAsArrayType.getDimensions()) {
                return this.isSubtype(new ArrayType(typeBasicType, typeAsArrayType.getDimensions() - possibleSupertypeAsArrayType.getDimensions()), (ReferenceType)((ObjectType)possibleSupertypeBasicType));
            }
            if (!(typeBasicType instanceof ObjectType)) {
                return false;
            }
            return this.isSubtype((ObjectType)typeBasicType, (ObjectType)possibleSupertypeBasicType);
        }
        return false;
    }

    public boolean isSubtype(ClassDescriptor subDesc, ClassDescriptor superDesc) throws ClassNotFoundException {
        assert (subDesc != null);
        assert (superDesc != null);
        if (subDesc.equals(superDesc)) {
            return true;
        }
        try {
            SupertypeQueryResults supertypeQueryResults = this.getSupertypeQueryResults(subDesc);
            return supertypeQueryResults.containsType(superDesc);
        }
        catch (ClassNotFoundException e) {
            XClass xclass = AnalysisContext.currentXFactory().getXClass(subDesc);
            if (xclass != null && superDesc.equals(xclass.getSuperclassDescriptor())) {
                return true;
            }
            throw e;
        }
    }

    public boolean isSubtype(ObjectType type, ObjectType possibleSupertype) throws ClassNotFoundException {
        if (DEBUG_QUERIES) {
            System.out.println("isSubtype: check " + type + " subtype of " + possibleSupertype);
        }
        if (type.equals(possibleSupertype)) {
            if (DEBUG_QUERIES) {
                System.out.println("  ==> yes, types are same");
            }
            return true;
        }
        ClassDescriptor typeClassDescriptor = DescriptorFactory.getClassDescriptor(type);
        ClassDescriptor possibleSuperclassClassDescriptor = DescriptorFactory.getClassDescriptor(possibleSupertype);
        SupertypeQueryResults supertypeQueryResults = this.getSupertypeQueryResults(typeClassDescriptor);
        if (DEBUG_QUERIES) {
            System.out.println("  Superclass set: " + supertypeQueryResults.supertypeSet);
        }
        boolean isSubtype = supertypeQueryResults.containsType(possibleSuperclassClassDescriptor);
        if (DEBUG_QUERIES) {
            if (isSubtype) {
                System.out.println("  ==> yes, " + possibleSuperclassClassDescriptor + " is in superclass set");
            } else {
                System.out.println("  ==> no, " + possibleSuperclassClassDescriptor + " is not in superclass set");
            }
        }
        return isSubtype;
    }

    public ReferenceType getFirstCommonSuperclass(ReferenceType a, ReferenceType b) throws ClassNotFoundException {
        if (a.equals(b)) {
            return a;
        }
        ReferenceType answer = this.checkFirstCommonSuperclassQueryCache(a, b);
        if (answer == null) {
            answer = this.computeFirstCommonSuperclassOfReferenceTypes(a, b);
            this.putFirstCommonSuperclassQueryCache(a, b, answer);
        }
        return answer;
    }

    private ReferenceType computeFirstCommonSuperclassOfReferenceTypes(ReferenceType a, ReferenceType b) throws ClassNotFoundException {
        boolean aIsArrayType = a instanceof ArrayType;
        boolean bIsArrayType = b instanceof ArrayType;
        if (aIsArrayType && bIsArrayType) {
            ArrayType aArrType = (ArrayType)a;
            ArrayType bArrType = (ArrayType)b;
            if (aArrType.getDimensions() == bArrType.getDimensions()) {
                return this.computeFirstCommonSuperclassOfSameDimensionArrays(aArrType, bArrType);
            }
            return this.computeFirstCommonSuperclassOfDifferentDimensionArrays(aArrType, bArrType);
        }
        if (aIsArrayType || bIsArrayType) {
            return ObjectType.OBJECT;
        }
        return this.getFirstCommonSuperclass((ObjectType)a, (ObjectType)b);
    }

    private ReferenceType computeFirstCommonSuperclassOfSameDimensionArrays(ArrayType aArrType, ArrayType bArrType) throws ClassNotFoundException {
        assert (aArrType.getDimensions() == bArrType.getDimensions());
        Type aBaseType = aArrType.getBasicType();
        Type bBaseType = bArrType.getBasicType();
        boolean aBaseIsObjectType = aBaseType instanceof ObjectType;
        boolean bBaseIsObjectType = bBaseType instanceof ObjectType;
        if (!aBaseIsObjectType || !bBaseIsObjectType) {
            assert (aBaseType instanceof BasicType || bBaseType instanceof BasicType);
            if (aArrType.getDimensions() > 1) {
                return new ArrayType(Type.OBJECT, aArrType.getDimensions() - 1);
            }
            assert (aArrType.getDimensions() == 1);
            return Type.OBJECT;
        }
        assert (aBaseType instanceof ObjectType);
        assert (bBaseType instanceof ObjectType);
        ObjectType firstCommonBaseType = this.getFirstCommonSuperclass((ObjectType)aBaseType, (ObjectType)bBaseType);
        return new ArrayType(firstCommonBaseType, aArrType.getDimensions());
    }

    private ReferenceType computeFirstCommonSuperclassOfDifferentDimensionArrays(ArrayType aArrType, ArrayType bArrType) {
        assert (aArrType.getDimensions() != bArrType.getDimensions());
        boolean aBaseTypeIsPrimitive = aArrType.getBasicType() instanceof BasicType;
        boolean bBaseTypeIsPrimitive = bArrType.getBasicType() instanceof BasicType;
        if (aBaseTypeIsPrimitive || bBaseTypeIsPrimitive) {
            int maxDimensions;
            int minDimensions;
            if (aArrType.getDimensions() < bArrType.getDimensions()) {
                minDimensions = aArrType.getDimensions();
                maxDimensions = bArrType.getDimensions();
            } else {
                minDimensions = bArrType.getDimensions();
                maxDimensions = aArrType.getDimensions();
            }
            if (minDimensions == 1) {
                return Type.OBJECT;
            }
            return new ArrayType(Type.OBJECT, maxDimensions - minDimensions);
        }
        return new ArrayType(Type.OBJECT, Math.min(aArrType.getDimensions(), bArrType.getDimensions()));
    }

    public ObjectType getFirstCommonSuperclass(ObjectType a, ObjectType b) throws ClassNotFoundException {
        if (a.equals(b)) {
            return a;
        }
        ObjectType firstCommonSupertype = (ObjectType)this.checkFirstCommonSuperclassQueryCache(a, b);
        if (firstCommonSupertype == null) {
            firstCommonSupertype = this.computeFirstCommonSuperclassOfObjectTypes(a, b);
            this.firstCommonSuperclassQueryCache.put(a, b, firstCommonSupertype);
        }
        return firstCommonSupertype;
    }

    private ObjectType computeFirstCommonSuperclassOfObjectTypes(ObjectType a, ObjectType b) throws ClassNotFoundException {
        ClassDescriptor aDesc = DescriptorFactory.getClassDescriptor(a);
        ClassDescriptor bDesc = DescriptorFactory.getClassDescriptor(b);
        ClassVertex aVertex = this.resolveClassVertex(aDesc);
        ClassVertex bVertex = this.resolveClassVertex(bDesc);
        Set<ClassDescriptor> aSuperTypes = this.computeKnownSupertypes(aDesc);
        Set<ClassDescriptor> bSuperTypes = this.computeKnownSupertypes(bDesc);
        if (bSuperTypes.contains(aDesc)) {
            return a;
        }
        if (aSuperTypes.contains(bDesc)) {
            return b;
        }
        ArrayList<ClassVertex> aSuperList = this.getAllSuperclassVertices(aVertex);
        ArrayList<ClassVertex> bSuperList = this.getAllSuperclassVertices(bVertex);
        int aIndex = aSuperList.size() - 1;
        ClassVertex lastCommonInBackwardsSearch = null;
        for (int bIndex = bSuperList.size() - 1; aIndex >= 0 && bIndex >= 0 && aSuperList.get(aIndex) == bSuperList.get(bIndex); --aIndex, --bIndex) {
            lastCommonInBackwardsSearch = aSuperList.get(aIndex);
        }
        ObjectType firstCommonSupertype = lastCommonInBackwardsSearch == null ? ObjectType.OBJECT : ObjectTypeFactory.getInstance(lastCommonInBackwardsSearch.getClassDescriptor().toDottedClassName());
        if (firstCommonSupertype.equals(ObjectType.OBJECT)) {
            ClassDescriptor objDesc = DescriptorFactory.getClassDescriptor(ObjectType.OBJECT);
            aSuperTypes.retainAll(bSuperTypes);
            aSuperTypes.remove(objDesc);
            for (ClassDescriptor c : aSuperTypes) {
                if (!c.getPackageName().equals(aDesc.getPackageName()) && !c.getPackageName().equals(bDesc.getPackageName())) continue;
                return ObjectTypeFactory.getInstance(c.toDottedClassName());
            }
            Iterator<ClassDescriptor> i$ = aSuperTypes.iterator();
            if (i$.hasNext()) {
                ClassDescriptor c;
                c = i$.next();
                return ObjectTypeFactory.getInstance(c.toDottedClassName());
            }
        }
        return firstCommonSupertype;
    }

    private void putFirstCommonSuperclassQueryCache(ReferenceType a, ReferenceType b, ReferenceType answer) {
        if (a.getSignature().compareTo(b.getSignature()) > 0) {
            ReferenceType tmp = a;
            a = b;
            b = tmp;
        }
        this.firstCommonSuperclassQueryCache.put(a, b, answer);
    }

    private ReferenceType checkFirstCommonSuperclassQueryCache(ReferenceType a, ReferenceType b) {
        if (a.getSignature().compareTo(b.getSignature()) > 0) {
            ReferenceType tmp = a;
            a = b;
            b = tmp;
        }
        return this.firstCommonSuperclassQueryCache.get(a, b);
    }

    private ArrayList<ClassVertex> getAllSuperclassVertices(ClassVertex vertex) throws ClassNotFoundException {
        ArrayList<ClassVertex> result = new ArrayList<ClassVertex>();
        for (ClassVertex cur = vertex; cur != null; cur = cur.getDirectSuperclass()) {
            if (!cur.isResolved()) {
                ClassDescriptor.throwClassNotFoundException(cur.getClassDescriptor());
            }
            result.add(cur);
        }
        return result;
    }

    public Set<ClassDescriptor> getSubtypes(ClassDescriptor classDescriptor) throws ClassNotFoundException {
        Set<ClassDescriptor> result = this.subtypeSetMap.get(classDescriptor);
        if (result == null) {
            result = this.computeKnownSubtypes(classDescriptor);
            this.subtypeSetMap.put(classDescriptor, result);
        }
        return result;
    }

    public boolean hasSubtypes(ClassDescriptor classDescriptor) throws ClassNotFoundException {
        Set<ClassDescriptor> subtypes = this.getDirectSubtypes(classDescriptor);
        if (DEBUG) {
            System.out.println("Direct subtypes of " + classDescriptor + " are " + subtypes);
        }
        return !subtypes.isEmpty();
    }

    public Set<ClassDescriptor> getDirectSubtypes(ClassDescriptor classDescriptor) throws ClassNotFoundException {
        ClassVertex startVertex = this.resolveClassVertex(classDescriptor);
        HashSet<ClassDescriptor> result = new HashSet<ClassDescriptor>();
        Iterator i = this.graph.incomingEdgeIterator(startVertex);
        while (i.hasNext()) {
            InheritanceEdge edge = (InheritanceEdge)i.next();
            result.add(((ClassVertex)edge.getSource()).getClassDescriptor());
        }
        return result;
    }

    public Set<ClassDescriptor> getTransitiveCommonSubtypes(ClassDescriptor classDescriptor1, ClassDescriptor classDescriptor2) throws ClassNotFoundException {
        Set<ClassDescriptor> subtypes1 = this.getSubtypes(classDescriptor1);
        HashSet<ClassDescriptor> result = new HashSet<ClassDescriptor>(subtypes1);
        Set<ClassDescriptor> subtypes2 = this.getSubtypes(classDescriptor2);
        result.retainAll(subtypes2);
        return result;
    }

    public Collection<XClass> getXClassCollection() {
        return Collections.unmodifiableCollection(this.xclassSet);
    }

    public void traverseSupertypes(ClassDescriptor start, InheritanceGraphVisitor visitor) throws ClassNotFoundException {
        LinkedList<SupertypeTraversalPath> workList = new LinkedList<SupertypeTraversalPath>();
        ClassVertex startVertex = this.resolveClassVertex(start);
        workList.addLast(new SupertypeTraversalPath(startVertex));
        while (!workList.isEmpty()) {
            SupertypeTraversalPath cur = (SupertypeTraversalPath)workList.removeFirst();
            ClassVertex vertex = cur.getNext();
            assert (!cur.hasBeenSeen(vertex.getClassDescriptor()));
            cur.markSeen(vertex.getClassDescriptor());
            if (!visitor.visitClass(vertex.getClassDescriptor(), vertex.getXClass()) || !vertex.isResolved()) continue;
            ClassDescriptor superclassDescriptor = vertex.getXClass().getSuperclassDescriptor();
            if (superclassDescriptor != null && this.traverseEdge(vertex, superclassDescriptor, false, visitor)) {
                this.addToWorkList(workList, cur, superclassDescriptor);
            }
            for (ClassDescriptor ifaceDesc : vertex.getXClass().getInterfaceDescriptorList()) {
                if (!this.traverseEdge(vertex, ifaceDesc, true, visitor)) continue;
                this.addToWorkList(workList, cur, ifaceDesc);
            }
        }
    }

    private void addToWorkList(LinkedList<SupertypeTraversalPath> workList, SupertypeTraversalPath curPath, ClassDescriptor supertypeDescriptor) {
        ClassVertex vertex = this.classDescriptorToVertexMap.get(supertypeDescriptor);
        assert (vertex != null);
        if (curPath.hasBeenSeen(vertex.getClassDescriptor())) {
            return;
        }
        SupertypeTraversalPath newPath = curPath.fork(vertex);
        workList.addLast(newPath);
    }

    private boolean traverseEdge(ClassVertex vertex, @CheckForNull ClassDescriptor supertypeDescriptor, boolean isInterfaceEdge, InheritanceGraphVisitor visitor) {
        if (supertypeDescriptor == null) {
            return false;
        }
        ClassVertex supertypeVertex = this.classDescriptorToVertexMap.get(supertypeDescriptor);
        if (supertypeVertex == null) {
            try {
                supertypeVertex = this.resolveClassVertex(supertypeDescriptor);
            }
            catch (ClassNotFoundException e) {
                supertypeVertex = this.addClassVertexForMissingClass(supertypeDescriptor, isInterfaceEdge);
            }
        }
        assert (supertypeVertex != null);
        return visitor.visitEdge(vertex.getClassDescriptor(), vertex.getXClass(), supertypeDescriptor, supertypeVertex.getXClass());
    }

    private Set<ClassDescriptor> computeKnownSubtypes(ClassDescriptor classDescriptor) throws ClassNotFoundException {
        LinkedList<GraphVertex> workList = new LinkedList<GraphVertex>();
        ClassVertex startVertex = this.resolveClassVertex(classDescriptor);
        workList.addLast(startVertex);
        HashSet<ClassDescriptor> result = new HashSet<ClassDescriptor>();
        while (!workList.isEmpty()) {
            ClassVertex current = (ClassVertex)workList.removeFirst();
            if (result.contains(current.getClassDescriptor())) continue;
            result.add(current.getClassDescriptor());
            Iterator i = this.graph.incomingEdgeIterator(current);
            while (i.hasNext()) {
                InheritanceEdge edge = (InheritanceEdge)i.next();
                workList.addLast(edge.getSource());
            }
        }
        return result;
    }

    private Set<ClassDescriptor> computeKnownSupertypes(ClassDescriptor classDescriptor) throws ClassNotFoundException {
        LinkedList<GraphVertex> workList = new LinkedList<GraphVertex>();
        ClassVertex startVertex = this.resolveClassVertex(classDescriptor);
        workList.addLast(startVertex);
        HashSet<ClassDescriptor> result = new HashSet<ClassDescriptor>();
        while (!workList.isEmpty()) {
            ClassVertex current = (ClassVertex)workList.removeFirst();
            if (result.contains(current.getClassDescriptor())) continue;
            result.add(current.getClassDescriptor());
            Iterator i = this.graph.outgoingEdgeIterator(current);
            while (i.hasNext()) {
                InheritanceEdge edge = (InheritanceEdge)i.next();
                workList.addLast(edge.getTarget());
            }
        }
        return result;
    }

    public SupertypeQueryResults getSupertypeQueryResults(ClassDescriptor classDescriptor) {
        SupertypeQueryResults supertypeQueryResults = this.supertypeSetMap.get(classDescriptor);
        if (supertypeQueryResults == null) {
            supertypeQueryResults = this.computeSupertypes(classDescriptor);
            this.supertypeSetMap.put(classDescriptor, supertypeQueryResults);
        }
        return supertypeQueryResults;
    }

    private SupertypeQueryResults computeSupertypes(ClassDescriptor classDescriptor) {
        if (DEBUG_QUERIES) {
            System.out.println("Computing supertypes for " + classDescriptor.toDottedClassName());
        }
        ClassVertex typeVertex = this.optionallyResolveClassVertex(classDescriptor);
        SupertypeQueryResults supertypeSet = new SupertypeQueryResults();
        LinkedList<GraphVertex> workList = new LinkedList<GraphVertex>();
        workList.addLast(typeVertex);
        while (!workList.isEmpty()) {
            ClassVertex vertex = (ClassVertex)workList.removeFirst();
            supertypeSet.addSupertype(vertex.getClassDescriptor());
            if (vertex.isResolved()) {
                if (DEBUG_QUERIES) {
                    System.out.println("  Adding supertype " + vertex.getClassDescriptor().toDottedClassName());
                }
            } else {
                if (DEBUG_QUERIES) {
                    System.out.println("  Encountered unresolved class " + vertex.getClassDescriptor().toDottedClassName() + " in supertype query");
                }
                supertypeSet.setEncounteredMissingClasses(true);
            }
            Iterator i = this.graph.outgoingEdgeIterator(vertex);
            while (i.hasNext()) {
                InheritanceEdge edge = (InheritanceEdge)i.next();
                workList.addLast(edge.getTarget());
            }
        }
        return supertypeSet;
    }

    private ClassVertex resolveClassVertex(ClassDescriptor classDescriptor) throws ClassNotFoundException {
        ClassVertex typeVertex = this.optionallyResolveClassVertex(classDescriptor);
        if (!typeVertex.isResolved()) {
            ClassDescriptor.throwClassNotFoundException(classDescriptor);
        }
        assert (typeVertex.isResolved());
        return typeVertex;
    }

    private ClassVertex optionallyResolveClassVertex(ClassDescriptor classDescriptor) {
        ClassVertex typeVertex = this.classDescriptorToVertexMap.get(classDescriptor);
        if (typeVertex == null) {
            XClass xclass = AnalysisContext.currentXFactory().getXClass(classDescriptor);
            typeVertex = xclass == null ? this.addClassVertexForMissingClass(classDescriptor, false) : this.addClassAndGetClassVertex(xclass);
        }
        return typeVertex;
    }

    private void addSupertypeEdges(ClassVertex vertex, LinkedList<XClass> workList) {
        XClass xclass = vertex.getXClass();
        ClassDescriptor superclassDescriptor = xclass.getSuperclassDescriptor();
        if (superclassDescriptor != null) {
            this.addInheritanceEdge(vertex, superclassDescriptor, false, workList);
        }
        for (ClassDescriptor ifaceDesc : xclass.getInterfaceDescriptorList()) {
            this.addInheritanceEdge(vertex, ifaceDesc, true, workList);
        }
    }

    private void addInheritanceEdge(ClassVertex vertex, ClassDescriptor superclassDescriptor, boolean isInterfaceEdge, @CheckForNull LinkedList<XClass> workList) {
        if (superclassDescriptor == null) {
            return;
        }
        ClassVertex superclassVertex = this.classDescriptorToVertexMap.get(superclassDescriptor);
        if (superclassVertex == null) {
            XClass superclassXClass = AnalysisContext.currentXFactory().getXClass(superclassDescriptor);
            if (superclassXClass == null) {
                superclassVertex = this.addClassVertexForMissingClass(superclassDescriptor, isInterfaceEdge);
            } else {
                superclassVertex = ClassVertex.createResolvedClassVertex(superclassDescriptor, superclassXClass);
                this.addVertexToGraph(superclassDescriptor, superclassVertex);
                if (workList != null) {
                    workList.addLast(superclassXClass);
                }
            }
        }
        assert (superclassVertex != null);
        if (this.graph.lookupEdge(vertex, superclassVertex) == null) {
            if (DEBUG) {
                System.out.println("  Add edge " + vertex.getClassDescriptor().toDottedClassName() + " -> " + superclassDescriptor.toDottedClassName());
            }
            this.graph.createEdge(vertex, superclassVertex);
        }
    }

    private ClassVertex addClassVertexForMissingClass(ClassDescriptor missingClassDescriptor, boolean isInterfaceEdge) {
        ClassVertex missingClassVertex = ClassVertex.createMissingClassVertex(missingClassDescriptor, isInterfaceEdge);
        missingClassVertex.setFinished(true);
        this.addVertexToGraph(missingClassDescriptor, missingClassVertex);
        AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(missingClassDescriptor);
        return missingClassVertex;
    }

    private static class SupertypeTraversalPath {
        ClassVertex next;
        Set<ClassDescriptor> seen;

        public SupertypeTraversalPath(@CheckForNull ClassVertex next) {
            this.next = next;
            this.seen = new HashSet<ClassDescriptor>();
        }

        public String toString() {
            return this.next.toString() + ":" + this.seen;
        }

        public ClassVertex getNext() {
            return this.next;
        }

        public boolean hasBeenSeen(ClassDescriptor classDescriptor) {
            return this.seen.contains(classDescriptor);
        }

        public void markSeen(ClassDescriptor classDescriptor) {
            this.seen.add(classDescriptor);
        }

        public void setNext(ClassVertex next) {
            assert (!this.hasBeenSeen(next.getClassDescriptor()));
            this.next = next;
        }

        public SupertypeTraversalPath fork(ClassVertex next) {
            SupertypeTraversalPath dup = new SupertypeTraversalPath(null);
            dup.seen.addAll(this.seen);
            dup.setNext(next);
            return dup;
        }
    }

    private static class SupertypeQueryResults {
        private Set<ClassDescriptor> supertypeSet = new HashSet<ClassDescriptor>();
        private boolean encounteredMissingClasses = false;

        private SupertypeQueryResults() {
        }

        public void addSupertype(ClassDescriptor classDescriptor) {
            this.supertypeSet.add(classDescriptor);
        }

        public void setEncounteredMissingClasses(boolean encounteredMissingClasses) {
            this.encounteredMissingClasses = encounteredMissingClasses;
        }

        public boolean containsType(ClassDescriptor possibleSupertypeClassDescriptor) throws ClassNotFoundException {
            if (this.supertypeSet.contains(possibleSupertypeClassDescriptor)) {
                return true;
            }
            if (!this.encounteredMissingClasses) {
                return false;
            }
            throw new ClassNotFoundException();
        }
    }
}

