/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.ArrayList;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.JavaClass;

public class FindPuzzlers
extends OpcodeStackDetector {
    static FieldDescriptor SYSTEM_OUT = new FieldDescriptor("java/lang/System", "out", "Ljava/io/PrintStream;", true);
    static FieldDescriptor SYSTEM_ERR = new FieldDescriptor("java/lang/System", "err", "Ljava/io/PrintStream;", true);
    final BugReporter bugReporter;
    final BugAccumulator bugAccumulator;
    int imul_constant;
    int imul_distance;
    boolean imul_operand_is_parameter;
    int prevOpcodeIncrementedRegister;
    int valueOfConstantArgumentToShift;
    int best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG;
    boolean constantArgumentToShift;
    boolean shiftOfNonnegativeValue;
    int ternaryConversionState = 0;
    int badlyComputingOddState;
    int prevOpCode;
    XMethod previousMethodInvocation;
    boolean isTigerOrHigher;
    Constant value_LDC2_W;

    public FindPuzzlers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code obj) {
        this.prevOpcodeIncrementedRegister = -1;
        this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG = 4;
        this.prevOpCode = 0;
        this.previousMethodInvocation = null;
        this.badlyComputingOddState = 0;
        this.resetIMulCastLong();
        this.imul_distance = 10000;
        this.ternaryConversionState = 0;
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    public void visit(JavaClass obj) {
        this.isTigerOrHigher = obj.getMajor() >= 49;
    }

    private void resetIMulCastLong() {
        this.imul_constant = 1;
        this.imul_operand_is_parameter = false;
    }

    private int adjustPriority(int factor, int priority) {
        if (factor <= 4) {
            return 5;
        }
        if (factor <= 10000) {
            return priority + 1;
        }
        if (factor <= 3600000) {
            return priority;
        }
        return priority - 1;
    }

    private int adjustMultiplier(Object constant, int mul) {
        if (!(constant instanceof Integer)) {
            return mul;
        }
        return Math.abs((Integer)constant) * mul;
    }

    public void sawOpcode(int seen) {
        ConstantLong longValue;
        String signature;
        int v;
        int pos;
        OpcodeStack.Item item;
        Object o;
        String sig;
        int v2;
        OpcodeStack.Item item2;
        Object o2;
        OpcodeStack.Item index;
        String clazz;
        OpcodeStack.Item item0;
        if (seen == 182 && this.getNameConstantOperand().equals("hashCode") && this.getSigConstantOperand().equals("()I") && this.stack.getStackDepth() > 0 && (item0 = this.stack.getStackItem(0)).getSignature().charAt(0) == '[') {
            this.bugReporter.reportBug(new BugInstance(this, "DMI_INVOKING_HASHCODE_ON_ARRAY", 2).addClassAndMethod(this).addValueSource(item0, this.getMethod(), this.getPC()).addSourceLine(this));
        }
        if (seen != 177 && this.isReturn(seen) && this.isRegisterStore(this.getPrevOpcode(1))) {
            int priority = 2;
            if (this.getMethodSig().endsWith(")Z")) {
                priority = 1;
            } else {
                if (this.getMethodSig().endsWith(")Ljava/lang/String;")) {
                    priority = 3;
                }
                if (this.getPC() == this.getCode().getCode().length - 1) {
                    ++priority;
                }
            }
            this.bugReporter.reportBug(new BugInstance(this, "DLS_DEAD_LOCAL_STORE_IN_RETURN", priority).addClassAndMethod(this).addSourceLine(this));
        }
        if (seen == 104) {
            if (this.imul_distance != 1) {
                this.resetIMulCastLong();
            }
            this.imul_distance = 0;
            if (this.stack.getStackDepth() > 1) {
                item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                this.imul_constant = this.adjustMultiplier(item0.getConstant(), this.imul_constant);
                this.imul_constant = this.adjustMultiplier(item1.getConstant(), this.imul_constant);
                if (item0.isInitialParameter() || item1.isInitialParameter()) {
                    this.imul_operand_is_parameter = true;
                }
            }
        } else {
            ++this.imul_distance;
        }
        if (this.prevOpCode == 104 && seen == 133) {
            int priority = this.adjustPriority(this.imul_constant, 2);
            if (priority >= 3 && this.imul_constant != 1000 && this.imul_operand_is_parameter) {
                priority = 2;
            }
            if (priority <= this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG) {
                this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG = priority;
                this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_INTEGER_MULTIPLY_CAST_TO_LONG", priority).addClassAndMethod(this), this);
            }
        }
        if (this.getMethodName().equals("<clinit>") && (seen == 179 || seen == 178 || seen == 184) && !(clazz = this.getClassConstantOperand()).equals(this.getClassName())) {
            try {
                JavaClass targetClass = Repository.lookupClass(clazz);
                if (Repository.instanceOf(targetClass, this.getThisClass())) {
                    int priority = 2;
                    if (seen == 178) {
                        --priority;
                    }
                    if (!targetClass.isPublic()) {
                        ++priority;
                    }
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION", priority).addClassAndMethod(this).addClass(this.getClassConstantOperand()), this);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((seen >= 46 && seen <= 53 || seen >= 79 && seen <= 86) && (index = this.stack.getStackItem(0)).getSpecialKind() == 6) {
            SourceLineAnnotation where = index.getPC() >= 0 ? SourceLineAnnotation.fromVisitedInstruction(this, index.getPC()) : SourceLineAnnotation.fromVisitedInstruction(this);
            this.bugAccumulator.accumulateBug(new BugInstance(this, "IM_AVERAGE_COMPUTATION_COULD_OVERFLOW", 2).addClassAndMethod(this), where);
        }
        if (!(seen != 153 && seen != 154 || this.getPrevOpcode(1) != 104 || this.getPrevOpcode(2) != 17 && this.getPrevOpcode(2) != 16 || this.getPrevOpcode(3) != 112)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "IM_MULTIPLYING_RESULT_OF_IREM", 3).addClassAndMethod(this), this);
        }
        if (!((seen != 147 || this.getPrevOpcode(1) != 124 || this.shiftOfNonnegativeValue || this.constantArgumentToShift && this.valueOfConstantArgumentToShift % 16 == 0) && (seen != 145 || this.getPrevOpcode(1) != 124 || this.shiftOfNonnegativeValue || this.constantArgumentToShift && this.valueOfConstantArgumentToShift % 8 == 0))) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_QUESTIONABLE_UNSIGNED_RIGHT_SHIFT", 2).addClassAndMethod(this), this);
        }
        this.constantArgumentToShift = false;
        this.shiftOfNonnegativeValue = false;
        if (seen == 124 || seen == 122 || seen == 120) {
            if (this.stack.getStackDepth() <= 1) {
                this.constantArgumentToShift = true;
                this.valueOfConstantArgumentToShift = 8;
            } else {
                Object rightHandSide = this.stack.getStackItem(0).getConstant();
                Object leftHandSide = this.stack.getStackItem(1).getConstant();
                this.shiftOfNonnegativeValue = this.stack.getStackItem(1).isNonNegative();
                if (rightHandSide instanceof Integer) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = (Integer)rightHandSide;
                    if (this.valueOfConstantArgumentToShift < 0 || this.valueOfConstantArgumentToShift >= 32) {
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_BAD_SHIFT_AMOUNT", this.valueOfConstantArgumentToShift < 0 ? 3 : 1).addClassAndMethod(this).addInt(this.valueOfConstantArgumentToShift).describe("INT_SHIFT"), this);
                    }
                }
                if (leftHandSide != null && leftHandSide instanceof Integer && (Integer)leftHandSide > 0) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = 8;
                }
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && this.getClassConstantOperand().equals("java/util/Date") && this.getNameConstantOperand().equals("setMonth") && this.getSigConstantOperand().equals("(I)V") && (o2 = (item2 = this.stack.getStackItem(0)).getConstant()) != null && o2 instanceof Integer && ((v2 = ((Integer)o2).intValue()) < 0 || v2 > 11)) {
            this.bugReporter.reportBug(new BugInstance(this, "DMI_BAD_MONTH", 1).addClassAndMethod(this).addInt(v2).describe("INT_VALUE").addCalledMethod(this).addSourceLine(this));
        }
        if ((seen == 182 && this.stack.getStackDepth() > 1 && this.getClassConstantOperand().equals("java/util/Calendar") && this.getNameConstantOperand().equals("set") || seen == 183 && this.stack.getStackDepth() > 1 && this.getClassConstantOperand().equals("java/util/GregorianCalendar") && this.getNameConstantOperand().equals("<init>")) && (sig = this.getSigConstantOperand()).startsWith("(III") && (o = (item = this.stack.getStackItem(pos = sig.length() - 5)).getConstant()) != null && o instanceof Integer && ((v = ((Integer)o).intValue()) < 0 || v > 11)) {
            this.bugReporter.reportBug(new BugInstance(this, "DMI_BAD_MONTH", 2).addClassAndMethod(this).addInt(v).describe("INT_VALUE").addCalledMethod(this).addSourceLine(this));
        }
        if (this.isRegisterStore() && (seen == 54 || seen == 59 || seen == 60 || seen == 61 || seen == 62) && this.getRegisterOperand() == this.prevOpcodeIncrementedRegister) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "DLS_OVERWRITTEN_INCREMENT", 1).addClassAndMethod(this), this);
        }
        this.prevOpcodeIncrementedRegister = seen == 132 ? this.getRegisterOperand() : -1;
        switch (this.badlyComputingOddState) {
            case 0: {
                if (seen != 5) break;
                ++this.badlyComputingOddState;
                break;
            }
            case 1: {
                if (seen == 112) {
                    item = this.stack.getStackItem(1);
                    if (!item.isNonNegative() && item.getSpecialKind() != 11) {
                        ++this.badlyComputingOddState;
                        break;
                    }
                    this.badlyComputingOddState = 0;
                    break;
                }
                this.badlyComputingOddState = 0;
                break;
            }
            case 2: {
                if (seen == 4) {
                    ++this.badlyComputingOddState;
                    break;
                }
                this.badlyComputingOddState = 0;
                break;
            }
            case 3: {
                if (seen == 159 || seen == 160) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "IM_BAD_CHECK_FOR_ODD", 2).addClassAndMethod(this), this);
                }
                this.badlyComputingOddState = 0;
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && (this.getNameConstantOperand().equals("toString") && this.getSigConstantOperand().equals("()Ljava/lang/String;") || this.getNameConstantOperand().equals("append") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Ljava/lang/StringBuilder;") && this.getClassConstantOperand().equals("java/lang/StringBuilder") || this.getNameConstantOperand().equals("append") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Ljava/lang/StringBuffer;") && this.getClassConstantOperand().equals("java/lang/StringBuffer") || (this.getNameConstantOperand().equals("print") || this.getNameConstantOperand().equals("println")) && this.getSigConstantOperand().equals("(Ljava/lang/Object;)V")) && (signature = (item = this.stack.getStackItem(0)).getSignature()) != null && signature.startsWith("[")) {
            int priority;
            boolean debuggingContext = signature.equals("[Ljava/lang/StackTraceElement;");
            if (!debuggingContext) {
                for (CodeException e : this.getCode().getExceptionTable()) {
                    if (e.getHandlerPC() > this.getPC() || e.getHandlerPC() + 30 < this.getPC()) continue;
                    debuggingContext = true;
                }
                for (int i = 1; !debuggingContext && i < this.stack.getStackDepth(); ++i) {
                    XField f;
                    OpcodeStack.Item e = this.stack.getStackItem(i);
                    if (e.getSignature().indexOf("Logger") >= 0 || e.getSignature().indexOf("Exception") >= 0) {
                        debuggingContext = true;
                    }
                    if ((f = e.getXField()) == null || !SYSTEM_ERR.equals(f.getFieldDescriptor()) && !SYSTEM_OUT.equals(f.getFieldDescriptor())) continue;
                    debuggingContext = true;
                }
            }
            Object name = null;
            int reg = item.getRegisterNumber();
            ArrayList<BugAnnotation> as = new ArrayList<BugAnnotation>();
            XField field = item.getXField();
            FieldAnnotation fieldAnnotation = null;
            if (field != null) {
                fieldAnnotation = FieldAnnotation.fromXField(field);
                fieldAnnotation.setDescription("FIELD_LOADED_FROM");
            }
            if (reg != -1) {
                LocalVariableAnnotation lva = LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), reg, this.getPC(), this.getPC() - 1);
                if (lva.isNamed()) {
                    as.add(lva);
                    if (fieldAnnotation != null) {
                        as.add(fieldAnnotation);
                    }
                } else {
                    if (fieldAnnotation != null) {
                        as.add(fieldAnnotation);
                    }
                    as.add(lva);
                }
            } else if (fieldAnnotation != null) {
                as.add(fieldAnnotation);
            } else {
                XMethod m = item.getReturnValueOf();
                if (m != null) {
                    MethodAnnotation methodAnnotation = MethodAnnotation.fromXMethod(m);
                    methodAnnotation.setDescription("METHOD_RETURN_VALUE_OF");
                    as.add(methodAnnotation);
                }
            }
            int n = priority = debuggingContext ? 2 : 1;
            if (!as.isEmpty()) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_INVOKING_TOSTRING_ON_ARRAY", priority).addClassAndMethod(this).addAnnotations(as), this);
            } else {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_INVOKING_TOSTRING_ON_ANONYMOUS_ARRAY", priority).addClassAndMethod(this), this);
            }
        }
        if (this.isTigerOrHigher) {
            if (this.previousMethodInvocation != null && this.prevOpCode == 183 && seen == 182) {
                String classNameForPreviousMethod = this.previousMethodInvocation.getClassName();
                String classNameForThisMethod = this.getClassConstantOperand();
                if (classNameForPreviousMethod.startsWith("java.lang.") && classNameForPreviousMethod.equals(classNameForThisMethod.replace('/', '.')) && this.getNameConstantOperand().endsWith("Value") && this.getSigConstantOperand().length() == 3) {
                    if (this.getSigConstantOperand().charAt(2) == this.previousMethodInvocation.getSignature().charAt(1)) {
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "BX_BOXING_IMMEDIATELY_UNBOXED", 2).addClassAndMethod(this), this);
                    } else {
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "BX_BOXING_IMMEDIATELY_UNBOXED_TO_PERFORM_COERCION", 2).addClassAndMethod(this), this);
                    }
                    this.ternaryConversionState = 1;
                } else {
                    this.ternaryConversionState = 0;
                }
            } else if (this.ternaryConversionState == 1) {
                this.ternaryConversionState = 133 < seen && seen <= 147 ? 2 : 0;
            } else if (this.ternaryConversionState == 2) {
                this.ternaryConversionState = 0;
                if (seen == 167) {
                    this.bugReporter.reportBug(new BugInstance(this, "BX_UNBOXED_AND_COERCED_FOR_TERNARY_OPERATOR", 2).addClassAndMethod(this).addSourceLine(this));
                }
            } else {
                this.ternaryConversionState = 0;
            }
        }
        if (seen == 184 && (this.getNameConstantOperand().startsWith("assert") || this.getNameConstantOperand().startsWith("fail")) && this.getMethodName().equals("run") && this.implementsRunnable(this.getThisClass())) {
            try {
                JavaClass targetClass;
                int size1 = Util.getSizeOfSurroundingTryBlock(this.getConstantPool(), this.getMethod().getCode(), "java/lang/Throwable", this.getPC());
                int size2 = Util.getSizeOfSurroundingTryBlock(this.getConstantPool(), this.getMethod().getCode(), "java/lang/Error", this.getPC());
                int size3 = Util.getSizeOfSurroundingTryBlock(this.getConstantPool(), this.getMethod().getCode(), "java/lang/AssertionFailureError", this.getPC());
                int size = Math.min(Math.min(size1, size2), size3);
                if (size == Integer.MAX_VALUE && (targetClass = AnalysisContext.currentAnalysisContext().lookupClass(this.getClassConstantOperand().replace('/', '.'))).getSuperclassName().startsWith("junit")) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "IJU_ASSERT_METHOD_INVOKED_FROM_RUN_METHOD", 2).addClassAndMethod(this), this);
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
        }
        this.previousMethodInvocation = seen == 183 && this.getClassConstantOperand().startsWith("java/lang/") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().length() == 4 ? XFactory.createReferencedXMethod(this) : (seen == 184 && this.getClassConstantOperand().startsWith("java/lang/") && this.getNameConstantOperand().equals("valueOf") && this.getSigConstantOperand().length() == 4 ? XFactory.createReferencedXMethod(this) : null);
        if (seen == 20) {
            this.value_LDC2_W = this.getConstantRefOperand();
        } else if (seen == 136 && this.getPrevOpcode(1) == 127 && this.getPrevOpcode(2) == 20 && this.value_LDC2_W instanceof ConstantLong && (longValue = (ConstantLong)this.value_LDC2_W).getBytes() == -268435457L) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "UNKNOWN", 2).addClassAndMethod(this), this);
        }
        this.prevOpCode = seen;
    }

    boolean implementsRunnable(JavaClass obj) {
        if (obj.getSuperclassName().equals("java.lang.Thread")) {
            return true;
        }
        for (String s : obj.getInterfaceNames()) {
            if (!s.equals("java.lang.Runnable")) continue;
            return true;
        }
        return false;
    }
}

