/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ResourceTrackingDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.detect.Lock;
import java.util.BitSet;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUnreleasedLock
extends ResourceTrackingDetector<Lock, LockResourceTracker> {
    private static final boolean DEBUG = SystemProperties.getBoolean("ful.debug");
    private int numAcquires = 0;

    public FindUnreleasedLock(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass jclass = classContext.getJavaClass();
        if (BCELUtil.preTiger(jclass)) {
            return;
        }
        boolean sawUtilConcurrentLocks = false;
        for (Constant c : jclass.getConstantPool().getConstantPool()) {
            if (!(c instanceof ConstantMethodref)) continue;
            ConstantMethodref m = (ConstantMethodref)c;
            ConstantClass cl = (ConstantClass)jclass.getConstantPool().getConstant(m.getClassIndex());
            ConstantUtf8 name = (ConstantUtf8)jclass.getConstantPool().getConstant(cl.getNameIndex());
            String nameAsString = name.getBytes();
            if (!nameAsString.startsWith("java/util/concurrent/locks")) continue;
            sawUtilConcurrentLocks = true;
        }
        if (sawUtilConcurrentLocks) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return false;
        }
        MethodGen methodGen = classContext.getMethodGen(method);
        return methodGen != null && methodGen.getName().toLowerCase().indexOf("lock") == -1 && (bytecodeSet.get(182) || bytecodeSet.get(185));
    }

    @Override
    public LockResourceTracker getResourceTracker(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        return new LockResourceTracker(this.bugReporter, classContext.getCFG(method), classContext.getValueNumberDataflow(method), classContext.getIsNullValueDataflow(method));
    }

    @Override
    public void inspectResult(ClassContext classContext, MethodGen methodGen, CFG cfg, Dataflow<ResourceValueFrame, ResourceValueAnalysis<Lock>> dataflow, Lock resource) {
        int exitStatus;
        JavaClass javaClass = classContext.getJavaClass();
        ResourceValueFrame exitFrame = dataflow.getResultFact(cfg.getExit());
        if (DEBUG) {
            System.out.println("Resource value at exit: " + exitFrame);
        }
        if ((exitStatus = exitFrame.getStatus()) == 1 || exitStatus == 2) {
            int priority;
            String bugType;
            if (exitStatus == 1) {
                bugType = "UL_UNRELEASED_LOCK";
                priority = 1;
            } else {
                bugType = "UL_UNRELEASED_LOCK_EXCEPTION_PATH";
                priority = 2;
            }
            String sourceFile = javaClass.getSourceFileName();
            this.bugAccumulator.accumulateBug(new BugInstance(this, bugType, priority).addClassAndMethod(methodGen, sourceFile), SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, resource.getLocation().getHandle()));
        }
    }

    @Override
    public void report() {
        if (DEBUG) {
            System.out.println("numAcquires=" + this.numAcquires);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LockResourceTracker
    implements ResourceTracker<Lock> {
        private RepositoryLookupFailureCallback lookupFailureCallback;
        private CFG cfg;
        private ValueNumberDataflow vnaDataflow;
        private IsNullValueDataflow isNullDataflow;

        public LockResourceTracker(RepositoryLookupFailureCallback lookupFailureCallback, CFG cfg, ValueNumberDataflow vnaDataflow, IsNullValueDataflow isNullDataflow) {
            this.lookupFailureCallback = lookupFailureCallback;
            this.cfg = cfg;
            this.vnaDataflow = vnaDataflow;
            this.isNullDataflow = isNullDataflow;
        }

        @Override
        public Lock isResourceCreation(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) throws DataflowAnalysisException {
            InvokeInstruction inv = this.toInvokeInstruction(handle.getInstruction());
            if (inv == null) {
                return null;
            }
            String className = inv.getClassName(cpg);
            String methodName = inv.getName(cpg);
            String methodSig = inv.getSignature(cpg);
            try {
                if (methodName.equals("lock") && methodSig.equals("()V") && Hierarchy.isSubtype(className, "java.util.concurrent.locks.Lock")) {
                    Location location = new Location(handle, basicBlock);
                    ValueNumberFrame frame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
                    ValueNumber lockValue = (ValueNumber)frame.getTopValue();
                    if (DEBUG) {
                        System.out.println("Lock value is " + lockValue.getNumber() + ", frame=" + frame.toString());
                    }
                    if (DEBUG) {
                        ++FindUnreleasedLock.this.numAcquires;
                    }
                    return new Lock(location, className, lockValue);
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
            return null;
        }

        @Override
        public boolean isResourceClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Lock resource, ResourceValueFrame frame) throws DataflowAnalysisException {
            InvokeInstruction inv = this.toInvokeInstruction(handle.getInstruction());
            if (inv == null) {
                return false;
            }
            String className = inv.getClassName(cpg);
            String methodName = inv.getName(cpg);
            String methodSig = inv.getSignature(cpg);
            ResourceValue topValue = (ResourceValue)frame.getTopValue();
            if (!topValue.isInstance()) {
                return false;
            }
            try {
                if (methodName.equals("unlock") && methodSig.equals("()V") && Hierarchy.isSubtype(className, "java.util.concurrent.locks.Lock")) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
            return false;
        }

        @Override
        public ResourceValueFrameModelingVisitor createVisitor(Lock resource, ConstantPoolGen cpg) {
            return new LockFrameModelingVisitor(cpg, this, resource, this.vnaDataflow, this.isNullDataflow);
        }

        @Override
        public boolean ignoreImplicitExceptions(Lock resource) {
            return false;
        }

        @Override
        public boolean ignoreExceptionEdge(Edge edge, Lock resource, ConstantPoolGen cpg) {
            try {
                Instruction ins;
                Location location = this.cfg.getExceptionThrowerLocation(edge);
                if (DEBUG) {
                    System.out.println("Exception thrower location: " + location);
                }
                if ((ins = location.getHandle().getInstruction()) instanceof GETFIELD) {
                    GETFIELD insGetfield = (GETFIELD)ins;
                    String fieldName = insGetfield.getFieldName(cpg);
                    if (DEBUG) {
                        System.out.println("Inspecting GETFIELD of " + fieldName + " at " + location);
                    }
                    if (fieldName.equals("lock")) {
                        return true;
                    }
                    IsNullValueFrame frame = (IsNullValueFrame)this.isNullDataflow.getFactAtLocation(location);
                    if (!frame.isValid()) {
                        return false;
                    }
                    IsNullValue receiver = (IsNullValue)frame.getInstance(ins, cpg);
                    boolean notNull = receiver.isDefinitelyNotNull();
                    if (DEBUG && notNull) {
                        System.out.println("Ignoring exception from non-null GETFIELD");
                    }
                    return notNull;
                }
                if (ins instanceof InvokeInstruction) {
                    InvokeInstruction iins = (InvokeInstruction)ins;
                    String methodName = iins.getMethodName(cpg);
                    if (methodName.startsWith("access$")) {
                        return true;
                    }
                    if (methodName.equals("readLock") || methodName.equals("writeLock")) {
                        return true;
                    }
                    if (methodName.equals("lock") || methodName.equals("unlock")) {
                        return true;
                    }
                }
                if (DEBUG) {
                    System.out.println("FOUND Exception thrower at: " + location);
                }
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Error while looking for exception edge", e);
            }
            return false;
        }

        @Override
        public boolean isParamInstance(Lock resource, int slot) {
            return false;
        }

        private InvokeInstruction toInvokeInstruction(Instruction ins) {
            short opcode = ins.getOpcode();
            if (opcode != 182 && opcode != 185) {
                return null;
            }
            return (InvokeInstruction)ins;
        }
    }

    private static class LockFrameModelingVisitor
    extends ResourceValueFrameModelingVisitor {
        private LockResourceTracker resourceTracker;
        private Lock lock;
        private ValueNumberDataflow vnaDataflow;

        public LockFrameModelingVisitor(ConstantPoolGen cpg, LockResourceTracker resourceTracker, Lock lock, ValueNumberDataflow vnaDataflow, IsNullValueDataflow isNullDataflow) {
            super(cpg);
            this.resourceTracker = resourceTracker;
            this.lock = lock;
            this.vnaDataflow = vnaDataflow;
        }

        public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock) throws DataflowAnalysisException {
            Location creationPoint;
            Instruction ins = handle.getInstruction();
            ConstantPoolGen cpg = this.getCPG();
            ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
            int status = -1;
            if (DEBUG) {
                System.out.println("PC : " + handle.getPosition() + " " + ins);
            }
            if (DEBUG && ins instanceof InvokeInstruction) {
                InvokeInstruction iins = (InvokeInstruction)ins;
                System.out.println("  " + ins.toString(cpg.getConstantPool()));
            }
            if (DEBUG) {
                System.out.println("resource frame before instruction: " + frame.toString());
            }
            if (handle == (creationPoint = this.lock.getLocation()).getHandle() && basicBlock == creationPoint.getBasicBlock()) {
                status = 1;
                if (DEBUG) {
                    System.out.println("OPEN");
                }
            } else if (this.resourceTracker.isResourceClose(basicBlock, handle, cpg, this.lock, frame)) {
                status = 3;
                if (DEBUG) {
                    System.out.println("CLOSE");
                }
            }
            this.analyzeInstruction(ins);
            int updatedNumSlots = frame.getNumSlots();
            ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(new Location(handle, basicBlock));
            if (DEBUG) {
                System.out.println("vna frame after instruction: " + vnaFrame.toString());
                System.out.println("Lock value number: " + this.lock.getLockValue());
                if (this.lock.getLockValue().hasFlag(1)) {
                    System.out.println("is return value");
                }
            }
            for (int i = 0; i < updatedNumSlots; ++i) {
                if (DEBUG) {
                    System.out.println("Slot " + i);
                    System.out.println("  Lock value number: " + vnaFrame.getValue(i));
                    if (((ValueNumber)vnaFrame.getValue(i)).hasFlag(1)) {
                        System.out.println("  is return value");
                    }
                }
                if (!vnaFrame.fuzzyMatch(this.lock.getLockValue(), (ValueNumber)vnaFrame.getValue(i))) continue;
                if (DEBUG) {
                    System.out.println("Saw lock value!");
                }
                frame.setValue(i, ResourceValue.instance());
            }
            if (status != -1) {
                frame.setStatus(status);
            }
            if (DEBUG) {
                System.out.println("resource frame after instruction: " + frame.toString());
            }
        }

        protected boolean instanceEscapes(InvokeInstruction inv, int instanceArgNum) {
            return false;
        }
    }
}

