/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManager;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class SplitLayout
implements FindBugsLayoutManager {
    final MainFrame frame;
    JLabel sourceTitle;
    JSplitPane topLeftSPane;
    JSplitPane topSPane;
    JSplitPane summarySPane;
    JSplitPane mainSPane;

    public SplitLayout(MainFrame frame) {
        this.frame = frame;
    }

    public JMenu createWindowMenu() {
        return null;
    }

    public void initialize() {
        this.topLeftSPane = new JSplitPane(0, this.frame.bugListPanel(), this.frame.createCommentsInputPanel());
        this.topLeftSPane.setOneTouchExpandable(true);
        this.topLeftSPane.setDividerLocation(GUISaveState.getInstance().getSplitTreeComments());
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new BorderLayout());
        this.sourceTitle = new JLabel();
        this.sourceTitle.setText(L10N.getLocalString("txt.source_listing", "<source listing>"));
        sourcePanel.add((Component)this.sourceTitle, "North");
        sourcePanel.add((Component)this.frame.createSourceCodePanel(), "Center");
        sourcePanel.add((Component)this.frame.createSourceSearchPanel(), "South");
        this.topSPane = new JSplitPane(1, this.topLeftSPane, sourcePanel);
        this.topSPane.setOneTouchExpandable(true);
        this.topSPane.setDividerLocation(GUISaveState.getInstance().getSplitTop());
        this.summarySPane = this.frame.summaryTab();
        this.mainSPane = new JSplitPane(0, this.topSPane, this.summarySPane);
        this.mainSPane.setOneTouchExpandable(true);
        this.mainSPane.setDividerLocation(GUISaveState.getInstance().getSplitMain());
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)this.mainSPane, "Center");
        this.frame.add((Component)this.frame.statusBar(), "South");
    }

    public void makeCommentsVisible() {
    }

    public void makeSourceVisible() {
    }

    public void saveState() {
        GUISaveState.getInstance().setSplitTreeComments(this.topLeftSPane.getDividerLocation());
        GUISaveState.getInstance().setSplitTop(this.topSPane.getDividerLocation());
        GUISaveState.getInstance().setSplitSummary(this.summarySPane.getDividerLocation());
        GUISaveState.getInstance().setSplitMain(this.mainSPane.getDividerLocation());
    }

    public void setSourceTitle(String title) {
        this.sourceTitle.setText(title);
    }
}

