/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.dao.ibatis;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.samples.jpetstore.dao.ProductDao;
import org.springframework.samples.jpetstore.domain.Product;

public class SqlMapProductDao
extends SqlMapClientDaoSupport
implements ProductDao {
    public List getProductListByCategory(String categoryId) throws DataAccessException {
        return this.getSqlMapClientTemplate().queryForList("getProductListByCategory", (Object)categoryId);
    }

    public Product getProduct(String productId) throws DataAccessException {
        return (Product)this.getSqlMapClientTemplate().queryForObject("getProduct", (Object)productId);
    }

    public List searchProductList(String keywords) throws DataAccessException {
        ProductSearch parameterObject = new ProductSearch(keywords);
        return this.getSqlMapClientTemplate().queryForList("searchProductList", (Object)parameterObject);
    }

    public static class ProductSearch {
        private List keywordList = new ArrayList();

        public ProductSearch(String keywords) {
            StringTokenizer splitter = new StringTokenizer(keywords, " ", false);
            while (splitter.hasMoreTokens()) {
                this.keywordList.add("%" + splitter.nextToken() + "%");
            }
        }

        public List getKeywordList() {
            return this.keywordList;
        }
    }
}

