/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import org.jboss.logging.Logger;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.jaxrpc.client.CallImpl;
import org.jboss.ws.core.jaxrpc.client.HandlerRegistryImpl;
import org.jboss.ws.core.jaxrpc.client.PortProxy;
import org.jboss.ws.core.jaxrpc.client.ServiceExt;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCClientMetaDataBuilder;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

public class ServiceImpl
implements ServiceExt {
    private static final Logger log = Logger.getLogger(ServiceImpl.class);
    private ServiceMetaData serviceMetaData;
    private URL wsdlLocation;
    private UnifiedServiceRefMetaData usrMetaData;
    private HandlerRegistryImpl handlerRegistry;

    ServiceImpl(QName serviceName) {
        UnifiedMetaData wsMetaData = new UnifiedMetaData(new ResourceLoaderAdapter());
        this.serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
        this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
    }

    ServiceImpl(QName serviceName, URL wsdlURL, URL mappingURL, URL securityURL) {
        this.wsdlLocation = wsdlURL;
        JAXRPCClientMetaDataBuilder builder = new JAXRPCClientMetaDataBuilder();
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, mappingURL, securityURL, null, ctxClassLoader);
        this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
    }

    ServiceImpl(QName serviceName, URL wsdlURL, JavaWsdlMapping mappingURL, WSSecurityConfiguration securityConfig, UnifiedServiceRefMetaData usrMetaData) {
        this.wsdlLocation = wsdlURL;
        this.usrMetaData = usrMetaData;
        JAXRPCClientMetaDataBuilder builder = new JAXRPCClientMetaDataBuilder();
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, mappingURL, securityConfig, usrMetaData, ctxClassLoader);
        this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlLocation;
    }

    public QName getServiceName() {
        return this.serviceMetaData.getServiceName();
    }

    public Call createCall(QName portName) throws ServiceException {
        String nsURI = portName.getNamespaceURI();
        this.serviceMetaData.assertTargetNamespace(nsURI);
        CallImpl call = new CallImpl(this, portName, null);
        this.initCallProperties(call, null);
        return call;
    }

    public Call createCall(QName portName, String operationName) throws ServiceException {
        String nsURI = portName.getNamespaceURI();
        this.serviceMetaData.assertTargetNamespace(nsURI);
        QName opName = new QName(nsURI, operationName);
        CallImpl call = new CallImpl(this, portName, opName);
        this.initCallProperties(call, null);
        return call;
    }

    public Call createCall(QName portName, QName opName) throws ServiceException {
        this.serviceMetaData.assertTargetNamespace(portName.getNamespaceURI());
        this.serviceMetaData.assertTargetNamespace(opName.getNamespaceURI());
        CallImpl call = new CallImpl(this, portName, opName);
        this.initCallProperties(call, null);
        return call;
    }

    public Call createCall() throws ServiceException {
        CallImpl call = new CallImpl(this);
        this.initCallProperties(call, null);
        return call;
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new ServiceException("Cannot find endpoint for name: " + portName);
        }
        ArrayList<Call> calls = new ArrayList<Call>();
        for (OperationMetaData opMetaData : epMetaData.getOperations()) {
            Call call = this.createCall(portName, opMetaData.getQName());
            calls.add(call);
        }
        Call[] callArr = new Call[calls.size()];
        calls.toArray(callArr);
        return callArr;
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException("Components should not use the getHandlerRegistry() method.");
    }

    public HandlerRegistry getDynamicHandlerRegistry() {
        return this.handlerRegistry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw new UnsupportedOperationException("Components should not use the getTypeMappingRegistry() method.");
    }

    public Iterator getPorts() throws ServiceException {
        ArrayList<QName> list = new ArrayList<QName>();
        if (this.serviceMetaData != null) {
            for (EndpointMetaData epMetaData : this.serviceMetaData.getEndpoints()) {
                list.add(epMetaData.getPortName());
            }
        }
        return list.iterator();
    }

    public Remote getPort(Class seiClass) throws ServiceException {
        if (seiClass == null) {
            throw new IllegalArgumentException("SEI class cannot be null");
        }
        String seiName = seiClass.getName();
        if (!Remote.class.isAssignableFrom(seiClass)) {
            throw new ServiceException("SEI does not implement java.rmi.Remote: " + seiName);
        }
        if (this.serviceMetaData == null) {
            throw new ServiceException("Service meta data not available");
        }
        try {
            EndpointMetaData epMetaData = this.serviceMetaData.getEndpointByServiceEndpointInterface(seiName);
            if (epMetaData == null && this.serviceMetaData.getEndpoints().size() == 1) {
                epMetaData = this.serviceMetaData.getEndpoints().get(0);
                epMetaData.setServiceEndpointInterfaceName(seiName);
            }
            if (epMetaData == null) {
                throw new ServiceException("Cannot find endpoint meta data for: " + seiName);
            }
            return this.createProxy(seiClass, epMetaData);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceException("Cannot create proxy", (Throwable)ex);
        }
    }

    public Remote getPort(QName portName, Class seiClass) throws ServiceException {
        if (seiClass == null) {
            throw new IllegalArgumentException("SEI class cannot be null");
        }
        if (this.serviceMetaData == null) {
            throw new ServiceException("Service meta data not available");
        }
        String seiName = seiClass.getName();
        if (!Remote.class.isAssignableFrom(seiClass)) {
            throw new ServiceException("SEI does not implement java.rmi.Remote: " + seiName);
        }
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new ServiceException("Cannot obtain endpoint meta data for: " + portName);
        }
        try {
            if (epMetaData.getServiceEndpointInterfaceName() == null) {
                epMetaData.setServiceEndpointInterfaceName(seiName);
            }
            return this.createProxy(seiClass, epMetaData);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceException("Cannot create proxy", (Throwable)ex);
        }
    }

    private Remote createProxy(Class seiClass, EndpointMetaData epMetaData) throws Exception {
        CallImpl call = new CallImpl(this, epMetaData);
        this.initStubProperties(call, seiClass.getName());
        if (this.initCallProperties(call, seiClass.getName()) > 0) {
            log.info((Object)"Deprecated use of <call-properties> on JAXRPC Stub. Use <stub-properties>");
        }
        PortProxy handler = new PortProxy(call);
        ClassLoader cl = epMetaData.getClassLoader();
        Remote proxy = (Remote)Proxy.newProxyInstance(cl, new Class[]{seiClass, Stub.class, StubExt.class}, (InvocationHandler)handler);
        this.setupHandlerChain(epMetaData);
        return proxy;
    }

    private int initStubProperties(CallImpl call, String seiName) {
        if (this.usrMetaData == null) {
            return 0;
        }
        int propCount = 0;
        for (UnifiedPortComponentRefMetaData upcRef : this.usrMetaData.getPortComponentRefs()) {
            if (!seiName.equals(upcRef.getServiceEndpointInterface())) continue;
            for (UnifiedStubPropertyMetaData prop : upcRef.getStubProperties()) {
                call.setProperty(prop.getPropName(), prop.getPropValue());
                ++propCount;
            }
        }
        return propCount;
    }

    private int initCallProperties(CallImpl call, String seiName) {
        this.setupHandlerChain(call.getEndpointMetaData());
        if (this.usrMetaData == null) {
            return 0;
        }
        int propCount = 0;
        for (UnifiedCallPropertyMetaData prop : this.usrMetaData.getCallProperties()) {
            call.setProperty(prop.getPropName(), prop.getPropValue());
            ++propCount;
        }
        if (seiName != null) {
            for (UnifiedPortComponentRefMetaData upcRef : this.usrMetaData.getPortComponentRefs()) {
                if (!seiName.equals(upcRef.getServiceEndpointInterface())) continue;
                for (UnifiedCallPropertyMetaData prop : upcRef.getCallProperties()) {
                    call.setProperty(prop.getPropName(), prop.getPropValue());
                    ++propCount;
                }
            }
        }
        return propCount;
    }

    public HandlerChain getHandlerChain(QName portName) {
        return this.handlerRegistry.getHandlerChainInstance(portName);
    }

    public void registerHandlerChain(QName portName, List infos, Set roles) {
        this.handlerRegistry.registerClientHandlerChain(portName, infos, roles);
    }

    void setupHandlerChain(EndpointMetaData epMetaData) {
        if (!epMetaData.isHandlersInitialized()) {
            QName portName = epMetaData.getPortName();
            HashSet<String> handlerRoles = new HashSet<String>();
            ArrayList<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>();
            for (HandlerMetaData handlerMetaData : epMetaData.getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ALL)) {
                HandlerMetaDataJAXRPC jaxrpcMetaData = (HandlerMetaDataJAXRPC)handlerMetaData;
                handlerRoles.addAll(jaxrpcMetaData.getSoapRoles());
                HashMap<String, Object> hConfig = new HashMap<String, Object>();
                for (UnifiedInitParamMetaData param : jaxrpcMetaData.getInitParams()) {
                    hConfig.put(param.getParamName(), param.getParamValue());
                }
                Set<QName> headers = jaxrpcMetaData.getSoapHeaders();
                QName[] headerArr = new QName[headers.size()];
                headers.toArray(headerArr);
                Class hClass = jaxrpcMetaData.getHandlerClass();
                hConfig.put(UnifiedHandlerMetaData.HandlerType.class.getName(), (Object)jaxrpcMetaData.getHandlerType());
                HandlerInfo info = new HandlerInfo(hClass, hConfig, headerArr);
                log.debug((Object)("Adding client side handler to endpoint '" + portName + "': " + info));
                handlerInfos.add(info);
            }
            if (handlerInfos.size() > 0) {
                this.registerHandlerChain(portName, handlerInfos, handlerRoles);
            }
            epMetaData.setHandlersInitialized(true);
        }
    }
}

