/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;

public class OPTS_MLST
extends AbstractCommand {
    private static final String[] AVAILABLE_TYPES = new String[]{"Size", "Modify", "Type", "Perm"};

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        session.resetState();
        String argument = request.getArgument();
        int spIndex = argument.indexOf(32);
        if (spIndex == -1) {
            out.write(FtpReplyUtil.translate(session, 503, "OPTS.MLST", null));
            return;
        }
        String listTypes = argument.substring(spIndex + 1);
        StringTokenizer st = new StringTokenizer(listTypes, ";");
        String[] types = new String[st.countTokens()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = st.nextToken();
        }
        String[] validatedTypes = this.validateSelectedTypes(types);
        if (validatedTypes != null) {
            session.setAttribute("MLST.types", validatedTypes);
            out.write(FtpReplyUtil.translate(session, 200, "OPTS.MLST", listTypes));
        } else {
            out.write(FtpReplyUtil.translate(session, 501, "OPTS.MLST", listTypes));
        }
    }

    private String[] validateSelectedTypes(String[] types) {
        if (types == null) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            boolean bMatch = false;
            for (int j = 0; j < AVAILABLE_TYPES.length; ++j) {
                if (!AVAILABLE_TYPES[j].equals(types[i])) continue;
                bMatch = true;
                break;
            }
            if (bMatch) continue;
            return null;
        }
        String[] selectedTypes = new String[types.length];
        System.arraycopy(types, 0, selectedTypes, 0, types.length);
        return selectedTypes;
    }
}

