/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.CallConfig;
import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.actions.ShowDesktopPanelAction;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.AttachmentContainer;
import com.eviware.soapui.impl.wsdl.WsdlAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlContentPart;
import com.eviware.soapui.impl.wsdl.WsdlHeaderPart;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.actions.operation.AddToMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.request.AddRequestToTestCaseAction;
import com.eviware.soapui.impl.wsdl.actions.request.CloneRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.DeleteRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.RenameRequestAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.submit.RequestTransportRegistry;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.support.FileAttachment;
import com.eviware.soapui.impl.wsdl.support.ModelItemIconAnimator;
import com.eviware.soapui.impl.wsdl.support.RequestFileAttachment;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.types.StringToStringMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlRequest
extends AbstractWsdlModelItem<CallConfig>
implements Request,
AttachmentContainer {
    public static final String RESPONSE_PROPERTY = WsdlRequest.class.getName() + "@response";
    public static final String RESPONSE_CONTENT_PROPERTY = WsdlRequest.class.getName() + "@response-content";
    public static final String ATTACHMENTS_PROPERTY = WsdlRequest.class.getName() + "@attachments";
    public static final String INLINE_RESPONSE_ATTACHMENTS = WsdlRequest.class.getName() + "@inline-response-attachments";
    public static final String EXPAND_MTOM_RESPONSE_ATTACHMENTS = WsdlRequest.class.getName() + "@expand-mtom-attachments";
    public static final String STRIP_WHITESPACES = WsdlRequest.class.getName() + "@strip-whitespaces";
    public static final String REQUEST_HEADERS_PROPERTY = WsdlRequest.class.getName() + "@request-headers";
    public static final String DISABLE_MULTIPART_ATTACHMENTS = WsdlRequest.class.getName() + "@disable-multipart-attachments";
    public static final String PW_TYPE_NONE = "None";
    public static final String PW_TYPE_DIGEST = "PasswordDigest";
    public static final String PW_TYPE_TEXT = "PasswordText";
    private final WsdlOperation operation;
    private WsdlResponse response;
    private static final Logger log = Logger.getLogger(WsdlRequest.class);
    protected List<FileAttachment> attachments = new ArrayList<FileAttachment>();
    private RequestIconAnimator iconAnimator;
    private Set<SubmitListener> listeners = new HashSet<SubmitListener>();
    private List<WsdlAttachmentPart> definedAttachmentParts;
    private InternalInterfaceListener interfaceListener = new InternalInterfaceListener();

    public WsdlRequest(WsdlOperation operation, CallConfig callConfig) {
        super(callConfig, operation, null);
        this.operation = operation;
        this.initActions();
        this.initEndpoints();
        this.initAttachments();
        this.iconAnimator = this.initIconAnimator();
        if (callConfig.getEncoding() == null || callConfig.getEncoding().length() == 0) {
            callConfig.setEncoding("UTF-8");
        }
        this.addSubmitListener(this.iconAnimator);
        operation.getInterface().addPropertyChangeListener(this.interfaceListener);
        operation.getInterface().addInterfaceListener(this.interfaceListener);
    }

    private void initAttachments() {
        for (AttachmentConfig ac : ((CallConfig)this.getConfig()).getAttachmentList()) {
            RequestFileAttachment attachment = new RequestFileAttachment(ac, this);
            this.attachments.add(attachment);
        }
    }

    public void updateConfig(CallConfig request) {
        this.setConfig(request);
    }

    public ModelItemIconAnimator getIconAnimator() {
        return this.iconAnimator;
    }

    protected RequestIconAnimator initIconAnimator() {
        return new RequestIconAnimator();
    }

    protected void initEndpoints() {
        String[] endpoints;
        if (this.getEndpoint() == null && (endpoints = this.operation.getInterface().getEndpoints()).length > 0) {
            this.setEndpoint(endpoints[0]);
        }
    }

    protected void initActions() {
        this.addAction(new ShowDesktopPanelAction("Open Request Editor", "Opens the Request Editor for this request", this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new AddRequestToTestCaseAction(this));
        this.addAction(new AddToMockServiceAction(this));
        this.addAction(new CloneRequestAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new RenameRequestAction(this));
        this.addAction(new DeleteRequestAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/requests.html"));
    }

    @Override
    public String getRequestContent() {
        return ((CallConfig)this.getConfig()).getRequest();
    }

    @Override
    public void setEndpoint(String endpoint) {
        String old = this.getEndpoint();
        if (old != null && old.equals(endpoint)) {
            return;
        }
        ((CallConfig)this.getConfig()).setEndpoint(endpoint);
        this.notifyPropertyChanged(ENDPOINT_PROPERTY, old, endpoint);
    }

    @Override
    public String getEndpoint() {
        return ((CallConfig)this.getConfig()).getEndpoint();
    }

    @Override
    public String getEncoding() {
        return ((CallConfig)this.getConfig()).getEncoding();
    }

    @Override
    public void setEncoding(String encoding) {
        String old = this.getEncoding();
        ((CallConfig)this.getConfig()).setEncoding(encoding);
        this.notifyPropertyChanged(ENCODING_PROPERTY, old, encoding);
    }

    public StringToStringMap getRequestHeaders() {
        return StringToStringMap.fromXml(this.getSettings().getString(REQUEST_HEADERS_PROPERTY, null));
    }

    public void setRequestHeaders(StringToStringMap map) {
        StringToStringMap old = this.getRequestHeaders();
        this.getSettings().setString(REQUEST_HEADERS_PROPERTY, map.toXml());
        this.notifyPropertyChanged(REQUEST_HEADERS_PROPERTY, old, map);
    }

    public boolean isInlineResponseAttachments() {
        return this.getSettings().getBoolean(INLINE_RESPONSE_ATTACHMENTS);
    }

    public void setInlineResponseAttachments(boolean inlineResponseAttachments) {
        boolean old = this.getSettings().getBoolean(INLINE_RESPONSE_ATTACHMENTS);
        this.getSettings().setBoolean(INLINE_RESPONSE_ATTACHMENTS, inlineResponseAttachments);
        this.notifyPropertyChanged(INLINE_RESPONSE_ATTACHMENTS, old, inlineResponseAttachments);
    }

    public boolean isStripWhitespaces() {
        return this.getSettings().getBoolean(STRIP_WHITESPACES);
    }

    public void setStripWhitespaces(boolean stripWhitespaces) {
        boolean old = this.getSettings().getBoolean(STRIP_WHITESPACES);
        this.getSettings().setBoolean(STRIP_WHITESPACES, stripWhitespaces);
        this.notifyPropertyChanged(STRIP_WHITESPACES, old, stripWhitespaces);
    }

    public boolean isExpandMtomResponseAttachments() {
        return this.getSettings().getBoolean(EXPAND_MTOM_RESPONSE_ATTACHMENTS);
    }

    public void setExpandMtomResponseAttachments(boolean expandMtomResponseAttachments) {
        boolean old = this.getSettings().getBoolean(EXPAND_MTOM_RESPONSE_ATTACHMENTS);
        this.getSettings().setBoolean(EXPAND_MTOM_RESPONSE_ATTACHMENTS, expandMtomResponseAttachments);
        this.notifyPropertyChanged(EXPAND_MTOM_RESPONSE_ATTACHMENTS, old, expandMtomResponseAttachments);
    }

    public String getResponseContent() {
        return this.response == null ? null : this.response.getContentAsString();
    }

    public WsdlResponse getResponse() {
        return this.response;
    }

    @Override
    public WsdlOperation getOperation() {
        return this.operation;
    }

    public void setRequestContent(String request) {
        String old = this.getRequestContent();
        if (request.equals(old)) {
            return;
        }
        ((CallConfig)this.getConfig()).setRequest(request);
        this.definedAttachmentParts = null;
        this.notifyPropertyChanged(REQUEST_PROPERTY, old, request);
    }

    public void setResponse(WsdlResponse response, SubmitContext context) {
        WsdlResponse oldResponse = this.getResponse();
        this.response = response;
        this.notifyPropertyChanged(RESPONSE_PROPERTY, oldResponse, response);
    }

    @Override
    public ImageIcon getIcon() {
        return this.iconAnimator.getIcon();
    }

    public String getUsername() {
        CredentialsConfig credentialsConfig = ((CallConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            return null;
        }
        return credentialsConfig.getUsername();
    }

    public String getPassword() {
        CredentialsConfig credentialsConfig = ((CallConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            return null;
        }
        return credentialsConfig.getPassword();
    }

    public String getDomain() {
        CredentialsConfig credentialsConfig = ((CallConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            return null;
        }
        return credentialsConfig.getDomain();
    }

    public void setUsername(String username) {
        CredentialsConfig credentialsConfig = ((CallConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            credentialsConfig = ((CallConfig)this.getConfig()).addNewCredentials();
        }
        credentialsConfig.setUsername(username);
    }

    public void setPassword(String password) {
        CredentialsConfig credentialsConfig = ((CallConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            credentialsConfig = ((CallConfig)this.getConfig()).addNewCredentials();
        }
        credentialsConfig.setPassword(password);
    }

    public void setDomain(String domain) {
        CredentialsConfig credentialsConfig = ((CallConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            credentialsConfig = ((CallConfig)this.getConfig()).addNewCredentials();
        }
        credentialsConfig.setDomain(domain);
    }

    @Override
    public void addSubmitListener(SubmitListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSubmitListener(SubmitListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Submit submit(SubmitContext submitContext, boolean async) throws Request.SubmitException {
        String endpoint = PropertyExpansionRequestFilter.expandProperties(submitContext, this.getEndpoint());
        if (endpoint == null || endpoint.trim().length() == 0) {
            UISupport.showErrorMessage("Missing endpoint for request [" + this.getName() + "]");
            return null;
        }
        try {
            WsdlSubmit submitter = new WsdlSubmit(this, this.listeners.toArray(new SubmitListener[this.listeners.size()]), RequestTransportRegistry.getTransport(endpoint, submitContext));
            submitter.submitRequest(submitContext, async);
            return submitter;
        }
        catch (Exception e) {
            throw new Request.SubmitException(e.toString());
        }
    }

    public String getWssPasswordType() {
        return ((CallConfig)this.getConfig()).getWssPasswordType();
    }

    public void setWssPasswordType(String wssPasswordType) {
        ((CallConfig)this.getConfig()).setWssPasswordType(wssPasswordType);
    }

    @Override
    public Attachment attachFile(File file, boolean cache) {
        try {
            RequestFileAttachment fileAttachment = new RequestFileAttachment(file, cache, this);
            this.attachments.add(fileAttachment);
            this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, null, fileAttachment);
            return fileAttachment;
        }
        catch (IOException e) {
            UISupport.showErrorMessage(e);
            return null;
        }
    }

    @Override
    public int getAttachmentCount() {
        return this.attachments.size();
    }

    @Override
    public Attachment getAttachmentAt(int index) {
        return this.attachments.get(index);
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        ArrayList<FileAttachment> result = new ArrayList<FileAttachment>();
        for (FileAttachment attachment : this.attachments) {
            if (!attachment.getPart().equals(partName)) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttachment(Attachment attachment) {
        int ix = this.attachments.indexOf(attachment);
        this.attachments.remove(ix);
        try {
            this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, attachment, null);
        }
        finally {
            ((CallConfig)this.getConfig()).removeAttachment(ix);
        }
    }

    @Override
    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[this.attachments.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsdlAttachmentPart[] getDefinedAttachmentParts() {
        if (this.definedAttachmentParts == null) {
            try {
                UISupport.setHourglassCursor();
                this.definedAttachmentParts = AttachmentUtils.extractAttachmentParts(this.getOperation(), this.getRequestContent(), true);
            }
            catch (Exception e) {
                log.warn((Object)e.toString());
            }
            finally {
                UISupport.resetCursor();
            }
        }
        return this.definedAttachmentParts.toArray(new WsdlAttachmentPart[this.definedAttachmentParts.size()]);
    }

    @Override
    public WsdlAttachmentPart getAttachmentPart(String partName) {
        WsdlAttachmentPart[] parts;
        for (WsdlAttachmentPart part : parts = this.getDefinedAttachmentParts()) {
            if (!part.getName().equals(partName)) continue;
            return part;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAttachmentsTo(WsdlRequest newRequest) {
        if (this.getAttachmentCount() > 0) {
            try {
                UISupport.setHourglassCursor();
                for (int c = 0; c < this.getAttachmentCount(); ++c) {
                    try {
                        Attachment attachment = this.getAttachmentAt(c);
                        newRequest.addAttachment(attachment);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                UISupport.resetCursor();
            }
        }
    }

    private Attachment addAttachment(Attachment attachment) {
        if (attachment instanceof FileAttachment) {
            AttachmentConfig oldConfig = ((FileAttachment)attachment).getConfig();
            AttachmentConfig newConfig = (AttachmentConfig)((CallConfig)this.getConfig()).addNewAttachment().set((XmlObject)oldConfig);
            RequestFileAttachment newAttachment = new RequestFileAttachment(newConfig, this);
            this.attachments.add(newAttachment);
            return newAttachment;
        }
        log.error((Object)("Unkown attachment type: " + attachment));
        return null;
    }

    public void copyTo(WsdlRequest newRequest) {
        newRequest.setEncoding(this.getEncoding());
        newRequest.setEndpoint(this.getEndpoint());
        newRequest.setRequestContent(this.getRequestContent());
        newRequest.setWssPasswordType(this.getWssPasswordType());
        CredentialsConfig credentials = ((CallConfig)this.getConfig()).getCredentials();
        if (credentials != null) {
            ((CallConfig)newRequest.getConfig()).setCredentials((CredentialsConfig)credentials.copy());
        }
        this.copyAttachmentsTo(newRequest);
        newRequest.setRequestHeaders(this.getRequestHeaders());
    }

    @Override
    public boolean isMtomEnabled() {
        return this.getSettings().getBoolean(WsdlSettings.ENABLE_MTOM);
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.getSettings().setBoolean(WsdlSettings.ENABLE_MTOM, mtomEnabled);
        this.definedAttachmentParts = null;
    }

    @Override
    public void release() {
        super.release();
        this.getOperation().getInterface().removeInterfaceListener(this.interfaceListener);
        this.getOperation().getInterface().removePropertyChangeListener(this.interfaceListener);
    }

    @Override
    public MessagePart[] getRequestParts() {
        try {
            ArrayList<MessagePart> result = new ArrayList<MessagePart>();
            WsdlOperation op = this.getOperation();
            WsdlContext wsdlContext = op.getInterface().getWsdlContext();
            BindingOperation bindingOperation = op.findBindingOperation(wsdlContext.getDefinition());
            if (bindingOperation == null) {
                return new MessagePart[0];
            }
            List<WsdlUtils.SoapHeader> headers = WsdlUtils.getSoapHeaders(bindingOperation.getBindingInput().getExtensibilityElements());
            for (int i = 0; i < headers.size(); ++i) {
                WsdlUtils.SoapHeader header = headers.get(i);
                Message message = wsdlContext.getDefinition().getMessage(header.getMessage());
                if (message == null) {
                    log.error((Object)("Missing message for header: " + header.getMessage()));
                    continue;
                }
                Part part = message.getPart(header.getPart());
                if (part != null) {
                    SchemaType schemaType = this.getSchemaTypeForPart(wsdlContext, part);
                    if (schemaType == null) continue;
                    result.add(new WsdlHeaderPart(part.getName(), schemaType, part.getElementName(), this));
                    continue;
                }
                log.error((Object)("Missing part for header; " + header.getPart()));
            }
            Part[] parts = WsdlUtils.getInputParts(bindingOperation);
            for (int i = 0; i < parts.length; ++i) {
                SchemaType schemaType;
                Part part = parts[i];
                if (WsdlUtils.isAttachmentInputPart(part, bindingOperation) || (schemaType = this.getSchemaTypeForPart(wsdlContext, part)) == null) continue;
                result.add(new WsdlContentPart(part.getName(), schemaType, part.getElementName(), this));
            }
            result.addAll(Arrays.asList(this.getDefinedAttachmentParts()));
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MessagePart[0];
        }
    }

    public SchemaType getSchemaTypeForPart(WsdlContext wsdlContext, Part part) throws Exception {
        SchemaType schemaType = null;
        QName elementName = part.getElementName();
        if (elementName != null) {
            SchemaGlobalElement elm = wsdlContext.getSchemaTypeLoader().findElement(elementName);
            if (elm != null) {
                schemaType = elm.getType();
            } else {
                log.error((Object)("Could not find element [" + elementName + "] specified in part [" + part.getName() + "]"));
            }
        } else {
            QName typeName = part.getTypeName();
            if (typeName != null && (schemaType = wsdlContext.getSchemaTypeLoader().findType(typeName)) == null) {
                log.error((Object)("Could not find type [" + typeName + "] specified in part [" + part.getName() + "]"));
            }
        }
        return schemaType;
    }

    @Override
    public MessagePart[] getResponseParts() {
        try {
            ArrayList<MessagePart> result = new ArrayList<MessagePart>();
            WsdlOperation op = this.getOperation();
            WsdlContext wsdlContext = op.getInterface().getWsdlContext();
            BindingOperation bindingOperation = op.findBindingOperation(wsdlContext.getDefinition());
            if (bindingOperation == null) {
                return new MessagePart[0];
            }
            List<WsdlUtils.SoapHeader> headers = WsdlUtils.getSoapHeaders(bindingOperation.getBindingOutput().getExtensibilityElements());
            for (int i = 0; i < headers.size(); ++i) {
                WsdlUtils.SoapHeader header = headers.get(i);
                Message message = wsdlContext.getDefinition().getMessage(header.getMessage());
                if (message == null) {
                    log.error((Object)("Missing message for header: " + header.getMessage()));
                    continue;
                }
                Part part = message.getPart(header.getPart());
                if (part != null) {
                    SchemaType schemaType = this.getSchemaTypeForPart(wsdlContext, part);
                    if (schemaType == null) continue;
                    result.add(new WsdlHeaderPart(part.getName(), schemaType, part.getElementName(), this));
                    continue;
                }
                log.error((Object)("Missing part for header; " + header.getPart()));
            }
            Part[] parts = WsdlUtils.getOutputParts(bindingOperation);
            for (int i = 0; i < parts.length; ++i) {
                SchemaType schemaType;
                Part part = parts[i];
                if (WsdlUtils.isAttachmentOutputPart(part, bindingOperation) || (schemaType = this.getSchemaTypeForPart(wsdlContext, part)) == null) continue;
                result.add(new WsdlContentPart(part.getName(), schemaType, part.getElementName(), this));
            }
            result.addAll(Arrays.asList(this.getDefinedAttachmentParts()));
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MessagePart[0];
        }
    }

    @Override
    public boolean isMultipartEnabled() {
        return !this.getSettings().getBoolean(DISABLE_MULTIPART_ATTACHMENTS);
    }

    public void setMultipartEnabled(boolean multipartEnabled) {
        this.getSettings().setBoolean(DISABLE_MULTIPART_ATTACHMENTS, multipartEnabled);
    }

    protected class RequestIconAnimator
    extends ModelItemIconAnimator
    implements SubmitListener {
        public RequestIconAnimator() {
            super(WsdlRequest.this, "/request.gif", new String[]{"/exec_request_1.gif", "/exec_request_2.gif", "/exec_request_3.gif", "/exec_request_4.gif"});
        }

        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            if (this.isEnabled() && submit.getRequest() == this.getTarget()) {
                this.start();
            }
            return true;
        }

        public void afterSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() == this.getTarget()) {
                this.stop();
            }
        }
    }

    private class InternalInterfaceListener
    extends InterfaceListenerAdapter
    implements PropertyChangeListener {
        private InternalInterfaceListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(Interface.ENDPOINT_PROPERTY)) {
                String endpoint = WsdlRequest.this.getEndpoint();
                if (evt.getOldValue() != null && evt.getOldValue().equals(endpoint)) {
                    WsdlRequest.this.setEndpoint((String)evt.getNewValue());
                }
            }
        }
    }
}

